/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.yungnickyoung.minecraft.ribbits.RibbitsCommon;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;

public class MaracaInHandRenderer {
    public static final ModelResourceLocation MARACA_MODEL = new ModelResourceLocation(RibbitsCommon.id("maraca"), "inventory");
    public static final ModelResourceLocation MARACA_IN_HAND_MODEL = new ModelResourceLocation(RibbitsCommon.id("maraca_in_hand"), "inventory");

    public static void applyMaracaTransform(PoseStack poseStack, float partialTick, HumanoidArm arm, ItemStack handItem, float equipProgress) {
        int timerSize = 8;
        float rotAmp = 7.5f;
        float translationAmp = 0.15f;
        float tickModulo = Minecraft.getInstance().player.getUseItemRemainingTicks() % 8;
        float tickTimer = tickModulo - partialTick + 1.0f;
        float timerNormalized = tickTimer / 8.0f;
        float timerAngle = (1.0f - timerNormalized) * 2.0f * (float)Math.PI;
        float xRot = 7.5f * Mth.cos((float)timerAngle);
        float movement = 0.15f * Mth.cos((float)timerAngle);
        if (arm == HumanoidArm.RIGHT) {
            poseStack.translate(-0.25, 0.1, 0.25);
        } else {
            poseStack.translate(0.25, 0.1, 0.25);
        }
        poseStack.translate(0.0, 0.0, (double)movement);
        poseStack.mulPose(Axis.XP.rotationDegrees(xRot));
    }
}

