/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.crafting;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRecipes;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class BlackboardDuplicateRecipe
extends CustomRecipe {
    public BlackboardDuplicateRecipe(CraftingBookCategory category) {
        super(category);
    }

    private boolean isDrawnBlackboard(ItemStack stack) {
        return stack.has(ModComponents.BLACKBOARD.get());
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        ItemStack itemstack = null;
        ItemStack itemstack1 = null;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            Item item = stack.getItem();
            if (item == ModRegistry.BLACKBOARD_ITEM.get()) {
                if (this.isDrawnBlackboard(stack)) {
                    if (itemstack != null) {
                        return false;
                    }
                    itemstack = stack;
                    continue;
                }
                if (itemstack1 != null) {
                    return false;
                }
                itemstack1 = stack;
                continue;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return itemstack != null && itemstack1 != null;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (!this.isDrawnBlackboard(stack)) continue;
            ItemStack s = stack.copy();
            s.setCount(1);
            return s;
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList stacks = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack itemstack = inv.getItem(i);
            if (itemstack.isEmpty()) continue;
            Optional container = ForgeHelper.getCraftingRemainingItem((ItemStack)itemstack);
            if (container.isPresent()) {
                stacks.set(i, (Object)((ItemStack)container.get()));
                continue;
            }
            if (!this.isDrawnBlackboard(itemstack)) continue;
            ItemStack copy = itemstack.copy();
            copy.setCount(1);
            stacks.set(i, (Object)copy);
        }
        return stacks;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.BLACKBOARD_DUPLICATE.get();
    }
}

