/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.InventoryViewTooltip;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkClientCompat;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.integration.ShulkerBoxTooltipCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class SackItem
extends BlockItem {
    public SackItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        int inc;
        float amount;
        ServerPlayer player;
        super.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!CommonConfigs.Functional.SACK_PENALTY.get().booleanValue()) {
            return;
        }
        if (worldIn.getGameTime() % 27L == 0L && entityIn instanceof ServerPlayer && !(player = (ServerPlayer)entityIn).isCreative() && !entityIn.isSpectator() && (amount = ItemsUtil.getEncumbermentFromInventory(stack, player)) > (float)(inc = CommonConfigs.Functional.SACK_INCREMENT.get().intValue())) {
            player.addEffect(new MobEffectInstance(ModRegistry.OVERENCUMBERED.getHolder(), 200, ((int)amount - 1) / inc - 1, false, false, true));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        boolean sbtTooltips;
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        boolean quarkTooltips = CompatHandler.QUARK && QuarkClientCompat.canRenderQuarkTooltip();
        boolean bl = sbtTooltips = CompatHandler.SHULKER_BOX_TOOLTIP && ShulkerBoxTooltipCompat.hasPreviewProvider(stack);
        if (!quarkTooltips && !sbtTooltips) {
            ItemsUtil.addShulkerLikeTooltips(stack, tooltipComponents);
        }
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public boolean canFitInsideContainerItems(ItemStack stack) {
        return !stack.has(DataComponents.CONTAINER);
    }

    public void onDestroyed(ItemEntity pItemEntity) {
        ItemStack stack = pItemEntity.getItem();
        ItemContainerContents contents = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
        if (contents != null) {
            stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
            ItemUtils.onContainerDestroyed((ItemEntity)pItemEntity, (Iterable)contents.nonEmptyItemsCopy());
        }
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack incoming, Slot slot, ClickAction action, Player player, SlotAccess accessor) {
        if (!CompatHandler.QUARK || !QuarkCompat.isShulkerDropInOn()) {
            return false;
        }
        return ItemsUtil.tryInteractingWithContainerItem(stack, incoming, slot, action, player, true);
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (!CompatHandler.QUARK || !QuarkCompat.isShulkerDropInOn()) {
            return false;
        }
        return ItemsUtil.tryInteractingWithContainerItem(stack, slot.getItem(), slot, action, player, false);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack pStack) {
        boolean sbtTooltips;
        boolean quarkTooltips = CompatHandler.QUARK && QuarkClientCompat.canRenderQuarkTooltip();
        boolean bl = sbtTooltips = CompatHandler.SHULKER_BOX_TOOLTIP && ShulkerBoxTooltipCompat.hasPreviewProvider(pStack);
        if (quarkTooltips && !sbtTooltips && !pStack.has(DataComponents.CONTAINER_LOOT)) {
            ItemContainerContents container = (ItemContainerContents)pStack.get(DataComponents.CONTAINER);
            return Optional.of(new InventoryViewTooltip(container, CommonConfigs.Functional.SACK_SLOTS.get()));
        }
        return Optional.empty();
    }

    private void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    public static float getEncumber(ItemStack slotItem) {
        if (slotItem.is(ModTags.OVERENCUMBERING)) {
            ItemContainerContents contents = (ItemContainerContents)slotItem.get(DataComponents.CONTAINER);
            if (contents != null) {
                return contents != ItemContainerContents.EMPTY ? 1.0f : 0.0f;
            }
            return (float)slotItem.getCount() / (float)slotItem.getMaxStackSize();
        }
        return 0.0f;
    }
}

