/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.common.entities.dispenser_minecart.DispenserMinecartEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class DispenserMinecartItem
extends Item {
    public static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack execute(BlockSource pSource, ItemStack pStack) {
            double d3;
            RailShape railshape;
            Direction direction = (Direction)pSource.state().getValue((Property)DispenserBlock.FACING);
            ServerLevel level = pSource.level();
            Vec3 center = pSource.center();
            double d0 = center.x() + (double)direction.getStepX() * 1.125;
            double d1 = Math.floor(center.y()) + (double)direction.getStepY();
            double d2 = center.z() + (double)direction.getStepZ() * 1.125;
            BlockPos blockpos = pSource.pos().relative(direction);
            BlockState blockstate = level.getBlockState(blockpos);
            Block block = blockstate.getBlock();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock railBlock = (BaseRailBlock)block;
                v0 = ForgeHelper.getRailDirection((BaseRailBlock)railBlock, (BlockState)blockstate, (Level)level, (BlockPos)blockpos, null);
            } else {
                v0 = railshape = RailShape.NORTH_SOUTH;
            }
            if (blockstate.is(BlockTags.RAILS)) {
                d3 = railshape.isAscending() ? 0.6 : 0.1;
            } else {
                RailShape railShape;
                if (!blockstate.isAir() || !level.getBlockState(blockpos.below()).is(BlockTags.RAILS)) {
                    return this.defaultDispenseItemBehavior.dispense(pSource, pStack);
                }
                BlockState blockstate1 = level.getBlockState(blockpos.below());
                Block block2 = blockstate1.getBlock();
                if (block2 instanceof BaseRailBlock) {
                    BaseRailBlock railBlock = (BaseRailBlock)block2;
                    railShape = (RailShape)blockstate1.getValue(railBlock.getShapeProperty());
                } else {
                    railShape = RailShape.NORTH_SOUTH;
                }
                RailShape railshape1 = railShape;
                d3 = direction != Direction.DOWN && railshape1.isAscending() ? -0.4 : -0.9;
            }
            DispenserMinecartEntity abstractminecart = new DispenserMinecartEntity((Level)level, d0, d1 + d3, d2);
            if (pStack.has(DataComponents.CUSTOM_NAME)) {
                abstractminecart.setCustomName(pStack.getHoverName());
            }
            level.addFreshEntity((Entity)abstractminecart);
            pStack.shrink(1);
            return pStack;
        }

        protected void playSound(BlockSource blockSource) {
            blockSource.level().levelEvent(1000, blockSource.pos(), 0);
        }
    };

    public DispenserMinecartItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        BlockPos blockpos;
        Level level = pContext.getLevel();
        BlockState blockstate = level.getBlockState(blockpos = pContext.getClickedPos());
        if (!blockstate.is(BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack itemstack = pContext.getItemInHand();
        if (!level.isClientSide) {
            RailShape railShape;
            Block block = blockstate.getBlock();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock railBlock = (BaseRailBlock)block;
                railShape = ForgeHelper.getRailDirection((BaseRailBlock)railBlock, (BlockState)blockstate, (Level)level, (BlockPos)blockpos, null);
            } else {
                railShape = RailShape.NORTH_SOUTH;
            }
            RailShape railshape = railShape;
            double d0 = 0.0;
            if (railshape.isAscending()) {
                d0 = 0.5;
            }
            DispenserMinecartEntity abstractminecart = new DispenserMinecartEntity(level, (double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.0625 + d0, (double)blockpos.getZ() + 0.5);
            level.addFreshEntity((Entity)abstractminecart);
            level.gameEvent((Entity)pContext.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, blockpos);
        }
        itemstack.shrink(1);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

