/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.mixin;

import dev.corgitaco.dataanchor.data.TrackedDataContainer;
import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.type.chunk.ChunkTrackedData;
import java.util.Collection;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkSerializer.class})
public class ChunkSerializerMixin {
    @Inject(method={"write(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/ChunkAccess;)Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="RETURN")})
    private static void dataAnchor$write(ServerLevel level, ChunkAccess chunk, CallbackInfoReturnable<CompoundTag> cir) {
        if (chunk instanceof TrackedDataContainer) {
            TrackedDataContainer trackedDataContainer = (TrackedDataContainer)chunk;
            CompoundTag tag = (CompoundTag)cir.getReturnValue();
            CompoundTag trackedDataTag = new CompoundTag();
            Collection keys = trackedDataContainer.dataAnchor$getTrackedDataKeys();
            for (TrackedDataKey key : keys) {
                trackedDataContainer.dataAnchor$getTrackedData(key).ifPresent(trackedData -> {
                    ChunkTrackedData chunkTrackedData;
                    CompoundTag save;
                    if (trackedData instanceof ChunkTrackedData && (save = (chunkTrackedData = (ChunkTrackedData)trackedData).save()) != null) {
                        trackedDataTag.put(key.getId().toString(), (Tag)save);
                    }
                });
            }
            tag.put("TrackedData", (Tag)trackedDataTag);
        }
    }

    @Inject(method={"read(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/ai/village/poi/PoiManager;Lnet/minecraft/world/level/chunk/storage/RegionStorageInfo;Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/world/level/chunk/ProtoChunk;"}, at={@At(value="RETURN")})
    private static void dataAnchor$read(ServerLevel level, PoiManager poiManager, RegionStorageInfo regionStorageInfo, ChunkPos pos, CompoundTag tag, CallbackInfoReturnable<ProtoChunk> cir) {
        ChunkAccess returnValue = (ChunkAccess)cir.getReturnValue();
        if (returnValue instanceof ImposterProtoChunk) {
            ImposterProtoChunk imposterProtoChunk = (ImposterProtoChunk)returnValue;
            returnValue = imposterProtoChunk.getWrapped();
        }
        if (returnValue instanceof TrackedDataContainer) {
            TrackedDataContainer trackedDataContainer = (TrackedDataContainer)returnValue;
            CompoundTag trackedDataTag = tag.getCompound("TrackedData");
            for (TrackedDataKey key : trackedDataContainer.dataAnchor$getTrackedDataKeys()) {
                trackedDataContainer.dataAnchor$getTrackedData(key).ifPresent(trackedData -> {
                    if (trackedData instanceof ChunkTrackedData) {
                        ChunkTrackedData chunkTrackedData = (ChunkTrackedData)trackedData;
                        String idString = key.getId().toString();
                        if (trackedDataTag.contains(idString)) {
                            chunkTrackedData.load(trackedDataTag.getCompound(idString));
                        }
                    }
                });
            }
        }
    }
}

