/*
 * Decompiled with CFR 0.152.
 */
package io.github.ladysnake.pal.impl.mixin;

import io.github.ladysnake.pal.impl.PlayerAbilityView;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayerGameMode.class})
public abstract class ServerPlayerInteractionManagerMixin {
    @Unique
    private static final ThreadLocal<Boolean> PAL_FLYING = new ThreadLocal();
    @Final
    @Shadow
    protected ServerPlayer player;

    @Inject(method={"setGameModeForPlayer(Lnet/minecraft/world/level/GameType;Lnet/minecraft/world/level/GameType;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/GameType;updatePlayerAbilities(Lnet/minecraft/world/entity/player/Abilities;)V")})
    private void saveFlying(GameType newMode, GameType previousMode, CallbackInfo info) {
        PAL_FLYING.set(this.player.getAbilities().flying);
    }

    @Inject(method={"setGameModeForPlayer(Lnet/minecraft/world/level/GameType;Lnet/minecraft/world/level/GameType;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/GameType;updatePlayerAbilities(Lnet/minecraft/world/entity/player/Abilities;)V", shift=At.Shift.AFTER)})
    private void keepAbilities(GameType newMode, GameType previousMode, CallbackInfo info) {
        this.player.getAbilities().flying = PAL_FLYING.get();
        PlayerAbilityView.of((Player)this.player).refreshAllPalAbilities(false);
    }
}

