/*
 * Decompiled with CFR 0.152.
 */
package io.github.ladysnake.pal.impl;

import io.github.ladysnake.pal.PlayerAbility;
import io.github.ladysnake.pal.SimpleAbilityTracker;
import io.github.ladysnake.pal.impl.PalInternals;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import org.jetbrains.annotations.Contract;

public final class VanillaAbilityTracker
extends SimpleAbilityTracker {
    private final AbilitySetter setter;
    private final Predicate<Abilities> getter;

    public VanillaAbilityTracker(PlayerAbility abilityId, Player player, AbilitySetter setter, Predicate<Abilities> getter) {
        super(abilityId, player);
        this.setter = setter;
        this.getter = getter;
    }

    @Override
    protected void updateState(boolean enabled) {
        super.updateState(enabled);
        this.updateBacking(enabled);
    }

    private void updateBacking(boolean enabled) {
        this.setter.set(VanillaAbilityTracker.getGamemode(this.player), this.player.getAbilities(), enabled);
    }

    @Override
    protected void sync() {
        this.player.onUpdateAbilities();
    }

    @Override
    public boolean isEnabled() {
        return this.getter.test(this.player.getAbilities());
    }

    public void checkConflict() {
        boolean enabled = this.isEnabled();
        this.updateBacking(this.shouldBeEnabled());
        boolean expected = this.isEnabled();
        if (enabled != expected) {
            this.updateState(true);
            PalInternals.logTamperWarning(this.ability, enabled, expected);
        }
    }

    private static GameType getGamemode(Player player) {
        if (player.level().isClientSide) {
            PlayerInfo playerListEntry = Objects.requireNonNull(Minecraft.getInstance().getConnection()).getPlayerInfo(player.getGameProfile().getId());
            return playerListEntry != null ? playerListEntry.getGameMode() : GameType.SURVIVAL;
        }
        return ((ServerPlayer)player).gameMode.getGameModeForPlayer();
    }

    @FunctionalInterface
    public static interface AbilitySetter {
        @Contract(mutates="param2")
        public void set(GameType var1, Abilities var2, boolean var3);
    }
}

