/*
 * Decompiled with CFR 0.152.
 */
package io.github.ladysnake.pal;

import io.github.ladysnake.pal.AbilityTracker;
import io.github.ladysnake.pal.impl.PlayerAbilityView;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public final class PlayerAbility {
    private final BiFunction<PlayerAbility, Player, AbilityTracker> trackerFactory;
    private final ResourceLocation id;

    @ApiStatus.Internal
    PlayerAbility(ResourceLocation id, BiFunction<PlayerAbility, Player, AbilityTracker> trackerFactory) {
        this.id = id;
        this.trackerFactory = trackerFactory;
    }

    public AbilityTracker getTracker(Player player) {
        return PlayerAbilityView.of(player).get(this);
    }

    public boolean isEnabledFor(Player player) {
        return this.getTracker(player).isEnabled();
    }

    @Contract(value="_ -> new")
    @ApiStatus.Internal
    public AbilityTracker createTracker(Player player) {
        return this.trackerFactory.apply(this, player);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String toString() {
        return "PlayerAbility@" + String.valueOf(this.id);
    }
}

