/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.neoforge.mixin;

import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.satisfy.lilis_lucky_lures.core.item.AnglersHatItem;
import net.satisfy.lilis_lucky_lures.core.registry.ArmorRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={AnglersHatItem.class})
public abstract class HatItemMixin
extends ArmorItem {
    @Shadow
    @Final
    private ResourceLocation hatTexture;

    public HatItemMixin(Holder<ArmorMaterial> arg, ArmorItem.Type arg2, Item.Properties arg3) {
        super(arg, arg2, arg3);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){

            @NotNull
            public Model getGenericArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return ArmorRegistry.getHatModel(itemStack.getItem(), original.getHead());
            }
        });
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return this.hatTexture;
    }
}

