/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.neoforge.mixin;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.satisfy.lilis_lucky_lures.core.entity.FloatingDebrisEntity;
import net.satisfy.lilis_lucky_lures.core.registry.ObjectRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FishingHook.class})
public abstract class FishingHookMixin {
    @Inject(method={"shouldStopFishing(Lnet/minecraft/world/entity/player/Player;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectedShouldStopFishing(Player player, CallbackInfoReturnable<Boolean> cir) {
        ItemStack mainHandStack = player.getMainHandItem();
        ItemStack offHandStack = player.getOffhandItem();
        boolean isUsingMainHand = mainHandStack.is((Item)ObjectRegistry.BAMBOO_FISHING_ROD.get());
        boolean isUsingOffHand = offHandStack.is((Item)ObjectRegistry.BAMBOO_FISHING_ROD.get());
        if (isUsingMainHand || isUsingOffHand) {
            FishingHook fishingHook = (FishingHook)this;
            if (!player.isRemoved() && player.isAlive() && fishingHook.distanceToSqr((Entity)player) <= 1024.0) {
                cir.setReturnValue((Object)false);
            } else {
                fishingHook.discard();
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"retrieve(Lnet/minecraft/world/item/ItemStack;)I"}, at={@At(value="TAIL")})
    private void onRetrieve(ItemStack itemStack, CallbackInfoReturnable<Integer> cir) {
        int returnValue;
        Player owner;
        FishingHook fishingHook = (FishingHook)this;
        if (!fishingHook.level().isClientSide && (owner = fishingHook.getPlayerOwner()) != null && (returnValue = ((Integer)cir.getReturnValue()).intValue()) > 0) {
            Vec3 hookPosition = fishingHook.position();
            AABB hookBoundingBox = new AABB(hookPosition.x - 1.0, hookPosition.y - 1.0, hookPosition.z - 1.0, hookPosition.x + 1.0, hookPosition.y + 1.0, hookPosition.z + 1.0);
            List debrisEntities = fishingHook.level().getEntitiesOfClass(FloatingDebrisEntity.class, hookBoundingBox);
            if (!debrisEntities.isEmpty()) {
                FloatingDebrisEntity debrisEntity = (FloatingDebrisEntity)((Object)debrisEntities.get(0));
                debrisEntity.onFishHookInteract(owner);
            }
        }
    }
}

