/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.util;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.satisfy.lilis_lucky_lures.core.entity.FloatingBooksEntity;
import net.satisfy.lilis_lucky_lures.core.entity.FloatingDebrisEntity;
import net.satisfy.lilis_lucky_lures.core.entity.OceanFishPoolEntity;
import net.satisfy.lilis_lucky_lures.core.entity.RiverFishPoolEntity;
import net.satisfy.lilis_lucky_lures.core.registry.EntityTypeRegistry;
import org.joml.Vector3d;

public class FloatingPoolsSpawner {
    private static final int MAX_COUNT = 3;
    private static final int SPAWN_INTERVAL = 6000;
    private static BlockPos lastValidSpawn = null;
    private static long lastSpawnTime = 0L;

    private static void attemptSpawn(ServerLevel level) {
        if (level.players().isEmpty()) {
            return;
        }
        RandomSource random = level.random;
        ServerPlayer player = (ServerPlayer)level.players().get(random.nextInt(level.players().size()));
        if (lastValidSpawn == null || level.getGameTime() - lastSpawnTime > 12000L) {
            lastValidSpawn = FloatingPoolsSpawner.findValidSpawnPos(level, player.blockPosition());
            lastSpawnTime = level.getGameTime();
        }
        if (lastValidSpawn == null) {
            return;
        }
        int spawnX = lastValidSpawn.getX();
        int spawnY = lastValidSpawn.getY();
        int spawnZ = lastValidSpawn.getZ();
        AABB area = new AABB((double)(spawnX - 128), (double)(spawnY - 128), (double)(spawnZ - 128), (double)(spawnX + 128), (double)(spawnY + 128), (double)(spawnZ + 128));
        int totalCount = level.getEntitiesOfClass(FloatingDebrisEntity.class, area).size();
        totalCount += level.getEntitiesOfClass(FloatingBooksEntity.class, area).size();
        Holder biome = level.getBiome(lastValidSpawn);
        if (biome.is(BiomeTags.IS_OCEAN)) {
            totalCount += level.getEntitiesOfClass(OceanFishPoolEntity.class, area).size();
        } else if (biome.is(BiomeTags.IS_RIVER)) {
            totalCount += level.getEntitiesOfClass(RiverFishPoolEntity.class, area).size();
        }
        if (totalCount >= 3) {
            return;
        }
        ArrayList<Runnable> actions = new ArrayList<Runnable>();
        AABB smallArea = new AABB((double)(spawnX - 50), (double)(spawnY - 50), (double)(spawnZ - 50), (double)(spawnX + 50), (double)(spawnY + 50), (double)(spawnZ + 50));
        if (level.getEntitiesOfClass(FloatingDebrisEntity.class, smallArea).size() < 3) {
            actions.add(() -> {
                FloatingDebrisEntity debris = new FloatingDebrisEntity((EntityType<? extends FloatingDebrisEntity>)((EntityType)EntityTypeRegistry.FLOATING_DEBRIS.get()), (Level)level);
                Vector3d spawnPos = new Vector3d((double)spawnX + 0.5, (double)spawnY, (double)spawnZ + 0.5);
                debris.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
                level.addFreshEntity((Entity)debris);
            });
        }
        if (biome.is(BiomeTags.IS_OCEAN)) {
            actions.add(() -> {
                OceanFishPoolEntity ocean = new OceanFishPoolEntity((EntityType<? extends OceanFishPoolEntity>)((EntityType)EntityTypeRegistry.OCEAN_FISH_POOL.get()), (Level)level);
                Vector3d spawnPos = new Vector3d((double)spawnX + 0.5, (double)spawnY, (double)spawnZ + 0.5);
                ocean.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
                level.addFreshEntity((Entity)ocean);
            });
        } else if (biome.is(BiomeTags.IS_RIVER)) {
            actions.add(() -> {
                RiverFishPoolEntity river = new RiverFishPoolEntity((EntityType<? extends RiverFishPoolEntity>)((EntityType)EntityTypeRegistry.RIVER_FISH_POOL.get()), (Level)level);
                Vector3d spawnPos = new Vector3d((double)spawnX + 0.5, (double)spawnY, (double)spawnZ + 0.5);
                river.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
                level.addFreshEntity((Entity)river);
            });
        }
        actions.add(() -> {
            FloatingBooksEntity books = new FloatingBooksEntity((EntityType<? extends FloatingBooksEntity>)((EntityType)EntityTypeRegistry.FLOATING_BOOKS.get()), (Level)level);
            Vector3d spawnPos = new Vector3d((double)spawnX + 0.5, (double)spawnY, (double)spawnZ + 0.5);
            books.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
            level.addFreshEntity((Entity)books);
        });
        ((Runnable)actions.get(random.nextInt(actions.size()))).run();
    }

    private static BlockPos findValidSpawnPos(ServerLevel level, BlockPos center) {
        RandomSource random = level.random;
        for (int i = 0; i < 10; ++i) {
            int offsetZ;
            int offsetX = random.nextInt(200) - 100;
            BlockPos newPos = center.offset(offsetX, 0, offsetZ = random.nextInt(200) - 100);
            Holder biome = level.getBiome(newPos);
            if (!biome.is(BiomeTags.IS_RIVER) && !biome.is(BiomeTags.IS_OCEAN)) continue;
            int spawnY = level.getHeight(Heightmap.Types.WORLD_SURFACE, newPos.getX(), newPos.getZ()) - 2;
            return new BlockPos(newPos.getX(), spawnY, newPos.getZ());
        }
        return null;
    }

    public static void tick(ServerLevel level) {
        if (level.getGameTime() % 6000L == 0L) {
            FloatingPoolsSpawner.attemptSpawn(level);
        }
    }
}

