/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.satisfy.lilis_lucky_lures.core.block.CompletionistBannerBlock;
import net.satisfy.lilis_lucky_lures.core.block.CompletionistWallBannerBlock;
import net.satisfy.lilis_lucky_lures.core.block.ElasticFishingNetBlock;
import net.satisfy.lilis_lucky_lures.core.block.FishBagBlock;
import net.satisfy.lilis_lucky_lures.core.block.FishNetFenceBlock;
import net.satisfy.lilis_lucky_lures.core.block.FishTrapBlock;
import net.satisfy.lilis_lucky_lures.core.block.FishTrophyFrameBlock;
import net.satisfy.lilis_lucky_lures.core.block.HangingFrameBlock;
import net.satisfy.lilis_lucky_lures.core.block.RedstoneCoilBlock;
import net.satisfy.lilis_lucky_lures.core.item.AnglersHatItem;
import net.satisfy.lilis_lucky_lures.core.item.CookableSuspiciousStewItem;
import net.satisfy.lilis_lucky_lures.core.item.DynamiteItem;
import net.satisfy.lilis_lucky_lures.core.item.FishNetBlockItem;
import net.satisfy.lilis_lucky_lures.core.item.FishingNetItem;
import net.satisfy.lilis_lucky_lures.core.item.FloatingPoolsItem;
import net.satisfy.lilis_lucky_lures.core.item.FoodEffectItem;
import net.satisfy.lilis_lucky_lures.core.item.SoakedBagItem;
import net.satisfy.lilis_lucky_lures.core.item.SpearItem;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresIdentifier;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresUtil;

public class ObjectRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"lilis_lucky_lures", (ResourceKey)Registries.ITEM);
    public static final Registrar<Item> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"lilis_lucky_lures", (ResourceKey)Registries.BLOCK);
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final RegistrySupplier<Block> ELASTIC_FISHING_NET = ObjectRegistry.registerWithoutItem("elastic_fishing_net", () -> new ElasticFishingNetBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL)));
    public static final RegistrySupplier<Block> FISH_BAG = ObjectRegistry.registerWithItem("fish_bag", () -> new FishBagBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL)));
    public static final RegistrySupplier<Block> FISH_NET_FENCE = ObjectRegistry.registerWithoutItem("fish_net_fence", () -> new FishNetFenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL)));
    public static final RegistrySupplier<Block> FISH_TRAP = ObjectRegistry.registerWithItem("fish_trap", () -> new FishTrapBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final RegistrySupplier<Block> FISH_TROPHY_FRAME = ObjectRegistry.registerWithItem("fish_trophy_frame", () -> new FishTrophyFrameBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final RegistrySupplier<Block> HANGING_FRAME = ObjectRegistry.registerWithItem("hanging_frame", () -> new HangingFrameBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final RegistrySupplier<Block> LILIS_LUCKY_LURES_BANNER = ObjectRegistry.registerWithItem("lilis_lucky_lures_banner", () -> new CompletionistBannerBlock(BlockBehaviour.Properties.of().strength(1.0f).instrument(NoteBlockInstrument.BASS).noCollission().sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> LILIS_LUCKY_LURES_WALL_BANNER = ObjectRegistry.registerWithoutItem("lilis_lucky_lures_wall_banner", () -> new CompletionistWallBannerBlock(BlockBehaviour.Properties.of().strength(1.0f).instrument(NoteBlockInstrument.BASS).noCollission().sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> REDSTONE_COIL = ObjectRegistry.registerWithItem("redstone_coil", () -> new RedstoneCoilBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).lightLevel(state -> (Boolean)state.getValue((Property)RedstoneCoilBlock.ACTIVE) != false ? 8 : 0).pushReaction(PushReaction.IGNORE)));
    public static final RegistrySupplier<Item> ANGLERS_HAT = ObjectRegistry.registerItem("anglers_hat", () -> new AnglersHatItem((Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.HELMET, new Item.Properties().rarity(Rarity.RARE), LilisLuckyLuresIdentifier.identifier("textures/models/armor/anglers_hat.png")));
    public static final RegistrySupplier<Item> BAMBOO_FISHING_ROD = ObjectRegistry.registerItem("bamboo_fishing_rod", () -> new FishingRodItem(ObjectRegistry.getSettings().stacksTo(1).durability(32)));
    public static final RegistrySupplier<Item> COOKED_COD_MEAL = ObjectRegistry.registerItem("cooked_cod_meal", () -> new FoodEffectItem(ObjectRegistry.getFoodSettings(8, 0.8f), 3600, true));
    public static final RegistrySupplier<Item> DYNAMITE = ObjectRegistry.registerItem("dynamite", () -> new DynamiteItem(ObjectRegistry.getSettings().rarity(Rarity.UNCOMMON)));
    public static final RegistrySupplier<Item> FISHING_NET = ObjectRegistry.registerItem("fishing_net", () -> new FishingNetItem(ObjectRegistry.getSettings().stacksTo(1)));
    public static final RegistrySupplier<Item> FLOATING_BOOKS = ObjectRegistry.registerItem("floating_books", () -> new FloatingPoolsItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> FLOATING_DEBRIS = ObjectRegistry.registerItem("floating_debris", () -> new FloatingPoolsItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> FISH_NET = ObjectRegistry.registerItem("fish_net", () -> new FishNetBlockItem(ObjectRegistry.getSettings(), (Block)ELASTIC_FISHING_NET.get(), (Block)FISH_NET_FENCE.get()));
    public static final RegistrySupplier<Item> GRILLED_TROPICAL_FISH = ObjectRegistry.registerItem("grilled_tropical_fish", () -> new FoodEffectItem(ObjectRegistry.getFoodSettings(6, 0.7f), 3600, true));
    public static final RegistrySupplier<Item> OCEAN_FISH_POOL = ObjectRegistry.registerItem("ocean_fish_pool", () -> new FloatingPoolsItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> PUFFER_PLATER = ObjectRegistry.registerItem("puffer_plater", () -> new CookableSuspiciousStewItem(ObjectRegistry.getFoodSettings(5, 0.6f), true));
    public static final RegistrySupplier<Item> RIVER_FISH_POOL = ObjectRegistry.registerItem("river_fish_pool", () -> new FloatingPoolsItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> SALMON_ROLLS = ObjectRegistry.registerItem("salmon_rolls", () -> new FoodEffectItem(ObjectRegistry.getFoodSettings(10, 0.9f), 4800, true));
    public static final RegistrySupplier<Item> SOAKED_BAG = ObjectRegistry.registerItem("soaked_bag", () -> new SoakedBagItem(ObjectRegistry.getSettings().rarity(Rarity.RARE)));
    public static final RegistrySupplier<Item> SPEAR = ObjectRegistry.registerItem("spear", () -> new SpearItem(ObjectRegistry.getSettings().durability(124).rarity(Rarity.EPIC)));
    public static final RegistrySupplier<Item> UNCOOKED_COD_MEAL = ObjectRegistry.registerItem("uncooked_cod_meal", () -> new FoodEffectItem(ObjectRegistry.getFoodSettings(6, 0.7f), 200, false));
    public static final RegistrySupplier<Item> UNCOOKED_PUFFER_PLATER = ObjectRegistry.registerItem("uncooked_puffer_plater", () -> new CookableSuspiciousStewItem(ObjectRegistry.getFoodSettings(5, 0.4f), false));
    public static final RegistrySupplier<Item> UNCOOKED_TROPICAL_FISH = ObjectRegistry.registerItem("uncooked_tropical_fish", () -> new FoodEffectItem(ObjectRegistry.getFoodSettings(4, 0.5f), 200, false));

    public static void init() {
        ITEMS.register();
        BLOCKS.register();
    }

    private static Item.Properties getSettings(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties();
        consumer.accept(settings);
        return settings;
    }

    static Item.Properties getSettings() {
        return ObjectRegistry.getSettings(settings -> {});
    }

    private static Item.Properties getFoodSettings(int nutrition, float saturation) {
        return new Item.Properties().food(new FoodProperties.Builder().nutrition(nutrition).saturationModifier(saturation).alwaysEdible().build());
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block) {
        return LilisLuckyLuresUtil.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, LilisLuckyLuresIdentifier.identifier(name), block);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return LilisLuckyLuresUtil.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, LilisLuckyLuresIdentifier.identifier(path), block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String path, Supplier<T> itemSupplier) {
        return LilisLuckyLuresUtil.registerItem(ITEMS, ITEM_REGISTRAR, LilisLuckyLuresIdentifier.identifier(path), itemSupplier);
    }
}

