/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.lilis_lucky_lures.core.block.entity.CompletionistBannerEntity;
import net.satisfy.lilis_lucky_lures.core.block.entity.FishTrapBlockEntity;
import net.satisfy.lilis_lucky_lures.core.block.entity.FishTrophyFrameBlockEntity;
import net.satisfy.lilis_lucky_lures.core.block.entity.HangingFrameBlockEntity;
import net.satisfy.lilis_lucky_lures.core.block.entity.RedstoneCoilBlockEntity;
import net.satisfy.lilis_lucky_lures.core.entity.DynamiteEntity;
import net.satisfy.lilis_lucky_lures.core.entity.FloatingBooksEntity;
import net.satisfy.lilis_lucky_lures.core.entity.FloatingDebrisEntity;
import net.satisfy.lilis_lucky_lures.core.entity.OceanFishPoolEntity;
import net.satisfy.lilis_lucky_lures.core.entity.RiverFishPoolEntity;
import net.satisfy.lilis_lucky_lures.core.entity.projectile.ThrownSpearEntity;
import net.satisfy.lilis_lucky_lures.core.registry.ObjectRegistry;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresIdentifier;

public class EntityTypeRegistry {
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"lilis_lucky_lures", (ResourceKey)Registries.BLOCK_ENTITY_TYPE);
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"lilis_lucky_lures", (ResourceKey)Registries.ENTITY_TYPE);
    public static final RegistrySupplier<EntityType<DynamiteEntity>> DYNAMITE = EntityTypeRegistry.registerEntityType("dynamite", () -> EntityType.Builder.of(DynamiteEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).build(LilisLuckyLuresIdentifier.identifier("dynamite").toString()));
    public static final RegistrySupplier<EntityType<ThrownSpearEntity>> THROWN_SPEAR = EntityTypeRegistry.registerEntityType("thrown_spear", () -> EntityType.Builder.of(ThrownSpearEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).build(LilisLuckyLuresIdentifier.identifier("thrown_spear").toString()));
    public static final RegistrySupplier<EntityType<FloatingDebrisEntity>> FLOATING_DEBRIS = EntityTypeRegistry.registerEntityType("floating_debris", () -> EntityType.Builder.of(FloatingDebrisEntity::new, (MobCategory)MobCategory.CREATURE).sized(2.0f, 2.5f).build(LilisLuckyLuresIdentifier.identifier("floating_debris").toString()));
    public static final RegistrySupplier<EntityType<FloatingBooksEntity>> FLOATING_BOOKS = EntityTypeRegistry.registerEntityType("floating_books", () -> EntityType.Builder.of(FloatingBooksEntity::new, (MobCategory)MobCategory.CREATURE).sized(2.0f, 2.5f).build(LilisLuckyLuresIdentifier.identifier("floating_books").toString()));
    public static final RegistrySupplier<EntityType<RiverFishPoolEntity>> RIVER_FISH_POOL = EntityTypeRegistry.registerEntityType("river_fish_pool", () -> EntityType.Builder.of(RiverFishPoolEntity::new, (MobCategory)MobCategory.CREATURE).sized(2.0f, 2.5f).build(LilisLuckyLuresIdentifier.identifier("river_fish_pool").toString()));
    public static final RegistrySupplier<EntityType<OceanFishPoolEntity>> OCEAN_FISH_POOL = EntityTypeRegistry.registerEntityType("ocean_fish_pool", () -> EntityType.Builder.of(OceanFishPoolEntity::new, (MobCategory)MobCategory.CREATURE).sized(2.0f, 2.5f).build(LilisLuckyLuresIdentifier.identifier("ocean_fish_pool").toString()));
    public static final RegistrySupplier<BlockEntityType<FishTrapBlockEntity>> FISH_TRAP = EntityTypeRegistry.registerBlockEntity("fish_trap", () -> BlockEntityType.Builder.of(FishTrapBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.FISH_TRAP.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<HangingFrameBlockEntity>> HANGING_FRAME = EntityTypeRegistry.registerBlockEntity("hanging_frame", () -> BlockEntityType.Builder.of(HangingFrameBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.HANGING_FRAME.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<RedstoneCoilBlockEntity>> REDSTONE_COIL = EntityTypeRegistry.registerBlockEntity("redstone_coil", () -> BlockEntityType.Builder.of(RedstoneCoilBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.REDSTONE_COIL.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<FishTrophyFrameBlockEntity>> FISH_TROPHY_FRAME = EntityTypeRegistry.registerBlockEntity("fishing_trophy_frame", () -> BlockEntityType.Builder.of(FishTrophyFrameBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.FISH_TROPHY_FRAME.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<CompletionistBannerEntity>> LILIS_LUCKY_LURES_BANNER = EntityTypeRegistry.registerBlockEntity("lilis_lucky_lures_banner", () -> BlockEntityType.Builder.of(CompletionistBannerEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.LILIS_LUCKY_LURES_BANNER.get(), (Block)ObjectRegistry.LILIS_LUCKY_LURES_WALL_BANNER.get()}).build(null));

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String name, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(LilisLuckyLuresIdentifier.identifier(name), type);
    }

    private static <T extends EntityType<?>> RegistrySupplier<T> registerEntityType(String path, Supplier<T> type) {
        return ENTITY_TYPES.register(LilisLuckyLuresIdentifier.identifier(path), type);
    }

    public static void init() {
        ENTITY_TYPES.register();
        BLOCK_ENTITY_TYPES.register();
    }
}

