/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.satisfy.lilis_lucky_lures.core.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class FishTrapRecipe
implements Recipe<RecipeInput> {
    private final Ingredient baitItem;
    private final ItemStack catchItem;
    private final int catchCount;
    private final int minDuration;
    private final int maxDuration;
    private final Random random = new Random();

    public FishTrapRecipe(Ingredient baitItem, ItemStack catchItem, int catchCount, int minDuration, int maxDuration) {
        this.baitItem = baitItem;
        this.catchItem = catchItem;
        this.catchCount = catchCount;
        this.minDuration = minDuration;
        this.maxDuration = maxDuration;
    }

    public Ingredient getBaitItem() {
        return this.baitItem;
    }

    public ItemStack getCatchItem() {
        return this.catchItem.copy();
    }

    public int getCatchCount() {
        return this.catchCount;
    }

    public int getRandomDuration() {
        return this.minDuration + this.random.nextInt(this.maxDuration - this.minDuration + 1);
    }

    public int getMinDuration() {
        return this.minDuration;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonNullList = NonNullList.create();
        nonNullList.add((Object)this.baitItem);
        return nonNullList;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return this.baitItem.test(recipeInput.getItem(0));
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.catchItem.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.catchItem.copy();
    }

    @NotNull
    public ResourceLocation getId() {
        return RecipeTypeRegistry.FISH_TRAP_RECIPE_TYPE.getId();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeTypeRegistry.FISH_TRAP_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeTypeRegistry.FISH_TRAP_RECIPE_TYPE.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<FishTrapRecipe> {
        public static final StreamCodec<RegistryFriendlyByteBuf, FishTrapRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);
        private static final MapCodec<FishTrapRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("bait_item").forGetter(FishTrapRecipe::getBaitItem), (App)ItemStack.STRICT_CODEC.fieldOf("catch_result").forGetter(FishTrapRecipe::getCatchItem), (App)Codec.INT.fieldOf("catch_count").forGetter(FishTrapRecipe::getCatchCount), (App)Codec.INT.fieldOf("catch_duration_min").forGetter(FishTrapRecipe::getMinDuration), (App)Codec.INT.fieldOf("catch_duration_max").forGetter(FishTrapRecipe::getMinDuration)).apply((Applicative)instance, FishTrapRecipe::new));

        @NotNull
        public static FishTrapRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            Ingredient baitItem = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            ItemStack catchItem = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            int catchCount = buf.readInt();
            int minDuration = buf.readInt();
            int maxDuration = buf.readInt();
            return new FishTrapRecipe(baitItem, catchItem, catchCount, minDuration, maxDuration);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buf, FishTrapRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.baitItem);
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.catchItem);
            buf.writeInt(recipe.catchCount);
            buf.writeInt(recipe.minDuration);
            buf.writeInt(recipe.maxDuration);
        }

        public MapCodec<FishTrapRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FishTrapRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

