/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.satisfy.lilis_lucky_lures.core.entity.projectile.ThrownSpearEntity;
import org.jetbrains.annotations.NotNull;

public class SpearItem
extends Item
implements ProjectileItem {
    public SpearItem(Item.Properties properties) {
        super(properties.attributes(SpearItem.createAttributes()).component(DataComponents.TOOL, (Object)SpearItem.createToolProperties()));
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 6.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.7000000953674315, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public boolean canAttackBlock(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        return !player.isCreative();
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 72000;
    }

    public void releaseUsing(ItemStack itemStack, Level level, LivingEntity livingEntity, int i) {
        if (livingEntity instanceof Player) {
            float f;
            Player player = (Player)livingEntity;
            int var6 = this.getUseDuration(itemStack, livingEntity) - i;
            if (!(var6 < 10 || (f = EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)itemStack, (LivingEntity)player)) > 0.0f && !player.isInWaterOrRain() || SpearItem.isTooDamagedToUse(itemStack))) {
                Holder holder = EnchantmentHelper.pickHighestLevel((ItemStack)itemStack, (DataComponentType)EnchantmentEffectComponents.TRIDENT_SOUND).orElse(SoundEvents.TRIDENT_THROW);
                if (!level.isClientSide) {
                    itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)livingEntity.getUsedItemHand()));
                    if (f == 0.0f) {
                        ThrownSpearEntity thrownSpear = new ThrownSpearEntity(level, (LivingEntity)player, itemStack);
                        thrownSpear.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.5f, 1.0f);
                        if (player.hasInfiniteMaterials()) {
                            thrownSpear.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        level.addFreshEntity((Entity)thrownSpear);
                        level.playSound(null, (Entity)thrownSpear, (SoundEvent)holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (!player.hasInfiniteMaterials()) {
                            player.getInventory().removeItem(itemStack);
                        }
                    }
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                if (f > 0.0f) {
                    float g = player.getYRot();
                    float h = player.getXRot();
                    float k = -Mth.sin((float)(g * ((float)Math.PI / 180))) * Mth.cos((float)(h * ((float)Math.PI / 180)));
                    float l = -Mth.sin((float)(h * ((float)Math.PI / 180)));
                    float m = Mth.cos((float)(g * ((float)Math.PI / 180))) * Mth.cos((float)(h * ((float)Math.PI / 180)));
                    float n = Mth.sqrt((float)(k * k + l * l + m * m));
                    player.push((double)(k *= f / n), (double)(l *= f / n), (double)(m *= f / n));
                    player.startAutoSpinAttack(20, 8.0f, itemStack);
                    if (player.onGround()) {
                        player.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                    }
                    level.playSound(null, (Entity)player, (SoundEvent)holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (itemStack.getDamageValue() >= itemStack.getMaxDamage() - 1) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        player.startUsingItem(interactionHand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    private static boolean isTooDamagedToUse(ItemStack itemStack) {
        return itemStack.getDamageValue() >= itemStack.getMaxDamage() - 1;
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return true;
    }

    public boolean hurtEnemy(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        this.postHurtEnemy(itemStack, target, attacker);
        return true;
    }

    public boolean mineBlock(ItemStack itemStack, Level level, BlockState blockState, BlockPos blockPos, LivingEntity miner) {
        if (blockState.getDestroySpeed((BlockGetter)level, blockPos) > 0.0f) {
            itemStack.hurtAndBreak(2, miner, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    public void postHurtEnemy(ItemStack itemStack, LivingEntity livingEntity, LivingEntity livingEntity2) {
        itemStack.hurtAndBreak(1, livingEntity2, EquipmentSlot.MAINHAND);
    }

    public int getEnchantmentValue() {
        return 1;
    }

    @NotNull
    public Projectile asProjectile(Level level, Position position, ItemStack itemStack, Direction direction) {
        ThrownSpearEntity spearEntity = new ThrownSpearEntity(level, position.x(), position.y(), position.z(), itemStack.copyWithCount(1));
        spearEntity.pickup = AbstractArrow.Pickup.ALLOWED;
        return spearEntity;
    }
}

