/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.item;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresIdentifier;
import org.jetbrains.annotations.NotNull;

public class SoakedBagItem
extends Item {
    public SoakedBagItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        MinecraftServer minecraftServer;
        ItemStack stack = player.getItemInHand(hand);
        player.swing(hand);
        if (!world.isClientSide && (minecraftServer = world.getServer()) != null && world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            LootParams lootContext = new LootParams.Builder(server).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.ORIGIN, (Object)player.position()).create(LootContextParamSets.GIFT);
            LootTable treasure = minecraftServer.reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LilisLuckyLuresIdentifier.identifier("gameplay/soaked_bag")));
            ObjectArrayList lootItems = treasure.getRandomItems(lootContext);
            boolean hasSpace = lootItems.stream().allMatch(arg_0 -> ((Inventory)player.getInventory()).add(arg_0));
            if (!hasSpace) {
                lootItems.forEach(itemStack -> player.drop(itemStack, false));
            }
            world.playSound(player, player.blockPosition().above(), SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.PLAYERS, 1.0f, 1.0f);
            stack.shrink(1);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        Style actionStyle = Style.EMPTY.withColor(TextColor.fromRgb((int)16772275));
        Style descriptionStyle = Style.EMPTY.withColor(TextColor.fromRgb((int)5415884));
        MutableComponent combinedText = Component.literal((String)"[").setStyle(actionStyle).append((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.item.soaked_bag.action").setStyle(actionStyle)).append((Component)Component.literal((String)"] ").setStyle(actionStyle)).append((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.item.soaked_bag.description").setStyle(descriptionStyle));
        tooltip.add((Component)combinedText);
    }
}

