/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.item;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class FoodEffectItem
extends Item {
    private final int effectDuration;
    private final boolean cooked;

    public FoodEffectItem(Item.Properties properties, int effectDuration, boolean cooked) {
        super(properties);
        this.effectDuration = effectDuration;
        this.cooked = cooked;
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        ServerPlayer player;
        if (!level.isClientSide) {
            entity.addEffect(new MobEffectInstance(this.cooked ? MobEffects.LUCK : MobEffects.HUNGER, this.effectDuration));
            if (entity instanceof Player) {
                player = (Player)entity;
                int nutrition = this.cooked ? 6 : 2;
                float saturation = this.cooked ? 0.6f : 0.2f;
                player.getFoodData().eat(nutrition, saturation);
            }
        }
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
                player.getInventory().add(new ItemStack((ItemLike)Items.BOWL));
            }
        }
        level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.8f, 1.0f);
        level.gameEvent((Entity)entity, (Holder)GameEvent.EAT, entity.position());
        return stack;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 32;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (this.cooked) {
            MobEffectInstance effectInstance = new MobEffectInstance(MobEffects.LUCK, this.effectDuration);
            int effectLevel = effectInstance.getAmplifier();
            MutableComponent effectName = Component.translatable((String)((MobEffect)effectInstance.getEffect().value()).getDescriptionId());
            if (effectLevel > 0) {
                effectName.append(" ").append((Component)Component.translatable((String)("potion.potency." + effectLevel)));
            }
            String durationText = MobEffectUtil.formatDuration((MobEffectInstance)effectInstance, (float)1.0f, (float)1.0f).getString();
            MutableComponent effectDuration = Component.translatable((String)" (").append((Component)Component.literal((String)durationText)).append((Component)Component.literal((String)")"));
            tooltip.add((Component)effectName.append((Component)effectDuration).withStyle(((MobEffect)effectInstance.getEffect().value()).getCategory().getTooltipFormatting()));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.item.uncooked").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)13794630))));
        }
    }
}

