/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.item;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.satisfy.lilis_lucky_lures.core.entity.FloatingDebrisEntity;
import net.satisfy.lilis_lucky_lures.core.registry.EntityTypeRegistry;
import net.satisfy.lilis_lucky_lures.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class FloatingPoolsItem
extends Item {
    public FloatingPoolsItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        BlockHitResult hitResult = FloatingPoolsItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            FloatingDebrisEntity debris;
            AABB checkArea = new AABB(hitResult.getLocation().x - 4.0, hitResult.getLocation().y - 4.0, hitResult.getLocation().z - 4.0, hitResult.getLocation().x + 4.0, hitResult.getLocation().y + 4.0, hitResult.getLocation().z + 4.0);
            List nearbyDebris = level.getEntitiesOfClass(FloatingDebrisEntity.class, checkArea);
            if (!nearbyDebris.isEmpty()) {
                return InteractionResultHolder.fail((Object)itemStack);
            }
            if (!level.isClientSide && (debris = itemStack.is((Item)ObjectRegistry.FLOATING_BOOKS.get()) ? (FloatingDebrisEntity)((EntityType)EntityTypeRegistry.FLOATING_BOOKS.get()).create(level) : (itemStack.is((Item)ObjectRegistry.RIVER_FISH_POOL.get()) ? (FloatingDebrisEntity)((EntityType)EntityTypeRegistry.RIVER_FISH_POOL.get()).create(level) : (itemStack.is((Item)ObjectRegistry.OCEAN_FISH_POOL.get()) ? (FloatingDebrisEntity)((EntityType)EntityTypeRegistry.OCEAN_FISH_POOL.get()).create(level) : (FloatingDebrisEntity)((EntityType)EntityTypeRegistry.FLOATING_DEBRIS.get()).create(level)))) != null) {
                debris.setPos(hitResult.getLocation().x, hitResult.getLocation().y - 1.85, hitResult.getLocation().z);
                debris.setYRot(player.getYRot());
                if (level.noCollision((Entity)debris, debris.getBoundingBox())) {
                    level.addFreshEntity((Entity)debris);
                    level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, hitResult.getLocation());
                    if (!player.getAbilities().instabuild) {
                        itemStack.shrink(1);
                    }
                    this.showParticles(level, (HitResult)hitResult);
                    return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
                }
            }
            return InteractionResultHolder.fail((Object)itemStack);
        }
        return InteractionResultHolder.pass((Object)itemStack);
    }

    private void showParticles(Level level, HitResult hitResult) {
        if (level.isClientSide) {
            for (int i = 0; i < 20; ++i) {
                double xOffset = (level.random.nextDouble() - 0.5) * 2.0;
                double yOffset = (level.random.nextDouble() - 0.5) * 2.0;
                double zOffset = (level.random.nextDouble() - 0.5) * 2.0;
                level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, hitResult.getLocation().x + xOffset, hitResult.getLocation().y + yOffset, hitResult.getLocation().z + zOffset, 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.SPLASH, hitResult.getLocation().x + xOffset, hitResult.getLocation().y + yOffset, hitResult.getLocation().z + zOffset, 0.0, 0.0, 0.0);
            }
        }
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.item.not_obtainable").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)13794630)).withItalic(Boolean.valueOf(true))));
    }
}

