/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.item;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.satisfy.lilis_lucky_lures.core.entity.FloatingDebrisEntity;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresIdentifier;
import org.jetbrains.annotations.NotNull;

public class FishingNetItem
extends Item {
    private static final float SUCCESS_CHANCE = 0.8f;
    private static final int USE_DURATION = 100;
    private static final int COOLDOWN_TICKS = 40;
    private static final String TAG_STATE = "State";
    private static final String TAG_ENTITY_LOOT = "EntityLoot";
    private static final int STATE_EMPTY = 0;
    private static final int STATE_FULL = 1;

    public FishingNetItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        int state = this.getState(stack);
        if (state == 0) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)stack);
        }
        if (!level.isClientSide) {
            this.retrieveLoot(level, player, stack);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingUseTicks) {
        if (!level.isClientSide && entity instanceof Player) {
            FloatingDebrisEntity targetDebris;
            Player player = (Player)entity;
            if (this.getState(stack) == 0 && (targetDebris = this.getTargetDebris(level, player)) != null) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.spawnParticles(serverLevel, targetDebris.getX(), targetDebris.getY() + 0.5, targetDebris.getZ());
                if (remainingUseTicks % 20 == 0) {
                    level.playSound(null, targetDebris.getX(), targetDebris.getY(), targetDebris.getZ(), SoundEvents.BOAT_PADDLE_WATER, SoundSource.NEUTRAL, 1.25f, 1.0f);
                }
            }
        }
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.isClientSide && entity instanceof Player) {
            FloatingDebrisEntity targetDebris;
            Player player = (Player)entity;
            if (this.getState(stack) == 0 && (targetDebris = this.getTargetDebris(level, player)) != null) {
                if (level.getRandom().nextFloat() <= 0.8f) {
                    this.setState(stack, 1);
                    LootTable entityLootTable = targetDebris.getLootTable((ServerLevel)level);
                    LootParams lootParams = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.ORIGIN, (Object)player.position()).create(LootContextParamSets.GIFT);
                    ObjectArrayList entityLoot = entityLootTable.getRandomItems(lootParams);
                    ListTag lootListTag = new ListTag();
                    for (ItemStack item : entityLoot) {
                        lootListTag.add((Object)item.save((HolderLookup.Provider)level.registryAccess()));
                    }
                    CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
                    data = data.update(tag -> tag.put(TAG_ENTITY_LOOT, (Tag)lootListTag));
                    stack.set(DataComponents.CUSTOM_DATA, (Object)data);
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.GENERIC_SWIM, SoundSource.PLAYERS, 1.0f, 1.0f);
                    targetDebris.triggerInteraction();
                } else {
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.GENERIC_SPLASH, SoundSource.PLAYERS, 0.5f, 0.8f);
                }
                player.getCooldowns().addCooldown((Item)this, 40);
            }
        }
        return stack;
    }

    private void retrieveLoot(Level level, Player player, ItemStack stack) {
        ServerLevel serverLevel = (ServerLevel)level;
        LootTable fishingNetLootTable = serverLevel.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LilisLuckyLuresIdentifier.identifier("gameplay/fishing_net")));
        LootParams fishingNetLootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.ORIGIN, (Object)player.position()).create(LootContextParamSets.GIFT);
        ObjectArrayList fishingNetLoot = fishingNetLootTable.getRandomItems(fishingNetLootParams);
        fishingNetLoot.forEach(arg_0 -> ((Player)player).addItem(arg_0));
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = data.copyTag();
        if (!tag.isEmpty() && tag.contains(TAG_ENTITY_LOOT, 9)) {
            ListTag lootListTag = tag.getList(TAG_ENTITY_LOOT, 10);
            for (int i = 0; i < lootListTag.size(); ++i) {
                CompoundTag itemTag = lootListTag.getCompound(i);
                ItemStack entityLootItem = ItemStack.parse((HolderLookup.Provider)level.registryAccess(), (Tag)itemTag).orElseGet(() -> ItemStack.EMPTY);
                if (entityLootItem.isEmpty()) continue;
                player.addItem(entityLootItem);
            }
            data = data.update(t -> t.remove(TAG_ENTITY_LOOT));
            stack.set(DataComponents.CUSTOM_DATA, (Object)data);
        }
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 1.0f);
        this.setState(stack, 0);
    }

    private int getState(ItemStack stack) {
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (data.isEmpty()) {
            return 0;
        }
        CompoundTag tag = data.copyTag();
        return tag.contains(TAG_STATE) ? tag.getInt(TAG_STATE) : 0;
    }

    private void setState(ItemStack stack, int state) {
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        data = data.update(tag -> tag.putInt(TAG_STATE, state));
        if (state == 1) {
            stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(1));
        } else {
            stack.remove(DataComponents.CUSTOM_MODEL_DATA);
        }
        stack.set(DataComponents.CUSTOM_DATA, (Object)data);
    }

    private FloatingDebrisEntity getTargetDebris(Level level, Player player) {
        List debris = level.getEntitiesOfClass(FloatingDebrisEntity.class, player.getBoundingBox().inflate(1.0));
        return debris.stream().filter(entity -> this.isInSight(player, (FloatingDebrisEntity)((Object)entity))).min(Comparator.comparingDouble(arg_0 -> ((Player)player).distanceTo(arg_0))).orElse(null);
    }

    private boolean isInSight(Player player, FloatingDebrisEntity entity) {
        Vec3 toEntity;
        Vec3 lookVec = player.getLookAngle();
        double dot = lookVec.dot(toEntity = entity.position().subtract(player.getEyePosition()).normalize());
        return dot > 0.7;
    }

    private void spawnParticles(ServerLevel serverLevel, double x, double y, double z) {
        RandomSource random = serverLevel.getRandom();
        for (int i = 0; i < 15; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 1.5;
            double offsetY = random.nextDouble() + 0.5;
            double offsetZ = (random.nextDouble() - 0.5) * 1.5;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, x + offsetX, y + offsetY, z + offsetZ, 2, 0.0, 0.05, 0.0, 0.01);
        }
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 100;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BRUSH;
    }
}

