/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.item;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.satisfy.lilis_lucky_lures.core.entity.DynamiteEntity;
import org.jetbrains.annotations.NotNull;

public class DynamiteItem
extends Item {
    private static final SoundEvent SOUND_EVENT = SoundEvents.FLINTANDSTEEL_USE;
    private static final int COOLDOWN = 40;
    private static final float Z = 0.0f;
    private static final float VELOCITY = 1.5f;
    private static final float INACCURACY = 1.125f;

    public DynamiteItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.getItemInHand(interactionHand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SOUND_EVENT, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        player.getCooldowns().addCooldown((Item)this, 40);
        if (!level.isClientSide) {
            DynamiteEntity dynamite = new DynamiteEntity(level, (LivingEntity)player);
            dynamite.setPosRaw(player.getX(), player.getEyeY() - (double)0.1f, player.getZ());
            dynamite.setItem(itemstack);
            dynamite.setOwner((Entity)player);
            dynamite.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.125f);
            level.addFreshEntity((Entity)dynamite);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }
}

