/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.item;

import java.util.List;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class CookableSuspiciousStewItem
extends Item {
    private final boolean cooked;

    public CookableSuspiciousStewItem(Item.Properties properties, boolean cooked) {
        super(properties);
        this.cooked = cooked;
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        ServerPlayer player;
        if (!level.isClientSide) {
            if (this.cooked) {
                MobEffectInstance randomEffect = CookableSuspiciousStewItem.getRandomEffect();
                entity.addEffect(randomEffect);
            } else {
                entity.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 0));
            }
        }
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
                player.getInventory().add(new ItemStack((ItemLike)Items.BOWL));
            }
        }
        level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.8f, 1.0f);
        level.gameEvent((Entity)entity, (Holder)GameEvent.EAT, entity.position());
        return stack;
    }

    private static MobEffectInstance getRandomEffect() {
        MobEffect[] possibleEffects = new MobEffect[]{(MobEffect)MobEffects.REGENERATION.value(), (MobEffect)MobEffects.MOVEMENT_SPEED.value(), (MobEffect)MobEffects.DAMAGE_BOOST.value(), (MobEffect)MobEffects.ABSORPTION.value(), (MobEffect)MobEffects.LUCK.value(), (MobEffect)MobEffects.DAMAGE_RESISTANCE.value(), (MobEffect)MobEffects.JUMP.value(), (MobEffect)MobEffects.FIRE_RESISTANCE.value(), (MobEffect)MobEffects.WATER_BREATHING.value(), (MobEffect)MobEffects.NIGHT_VISION.value(), (MobEffect)MobEffects.SLOW_FALLING.value(), (MobEffect)MobEffects.CONDUIT_POWER.value(), (MobEffect)MobEffects.DOLPHINS_GRACE.value(), (MobEffect)MobEffects.MOVEMENT_SLOWDOWN.value(), (MobEffect)MobEffects.DIG_SLOWDOWN.value(), (MobEffect)MobEffects.CONFUSION.value(), (MobEffect)MobEffects.BLINDNESS.value(), (MobEffect)MobEffects.HUNGER.value(), (MobEffect)MobEffects.WEAKNESS.value(), (MobEffect)MobEffects.POISON.value()};
        Random random = new Random();
        MobEffect effect = possibleEffects[random.nextInt(possibleEffects.length)];
        int duration = 100 + random.nextInt(201);
        return new MobEffectInstance(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect), duration);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (!this.cooked) {
            tooltip.add((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.item.uncooked").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)13794630))));
        }
    }
}

