/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.item;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AnglersHatItem
extends ArmorItem {
    private final ResourceLocation hatTexture;

    public AnglersHatItem(Holder<ArmorMaterial> armorMaterial, ArmorItem.Type type, Item.Properties properties, ResourceLocation hatTexture) {
        super(armorMaterial, type, properties);
        this.hatTexture = hatTexture;
    }

    public ResourceLocation getHatTexture() {
        return this.hatTexture;
    }

    @NotNull
    public EquipmentSlot getEquipmentSlot() {
        return this.type.getSlot();
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.item.anglers_hat_worn").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xDAFFFF))).append((Component)Component.literal((String)" ")).append((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.item.anglers_hat_effect").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)5415884)))));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AnglersHatItem.applyLuckBonus(player);
        }
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return true;
    }

    public static void applyLuckBonus(Player player) {
        ItemStack helmet = player.getItemBySlot(EquipmentSlot.HEAD);
        if (helmet.getItem() instanceof AnglersHatItem) {
            player.addEffect(new MobEffectInstance(MobEffects.LUCK, 0, 0, true, false, true));
        }
    }
}

