/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.entity.projectile;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.satisfy.lilis_lucky_lures.core.registry.EntityTypeRegistry;
import net.satisfy.lilis_lucky_lures.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrownSpearEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.defineId(ThrownSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.defineId(ThrownSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private ItemStack spearItem;
    private boolean dealtDamage;
    public int clientSideReturnSpearTickCount;

    public ThrownSpearEntity(EntityType<? extends ThrownSpearEntity> entityType, Level level) {
        super(entityType, level);
        this.spearItem = new ItemStack((ItemLike)ObjectRegistry.SPEAR.get());
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(this.spearItem));
        this.entityData.set(ID_FOIL, (Object)this.spearItem.hasFoil());
    }

    public ThrownSpearEntity(Level level, LivingEntity livingEntity, ItemStack itemStack) {
        super((EntityType)EntityTypeRegistry.THROWN_SPEAR.get(), livingEntity, level, itemStack, null);
        this.spearItem = itemStack.copy();
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(itemStack));
        this.entityData.set(ID_FOIL, (Object)itemStack.hasFoil());
    }

    public ThrownSpearEntity(Level level, double x, double y, double z, ItemStack itemStack) {
        super((EntityType)EntityTypeRegistry.THROWN_SPEAR.get(), x, y, z, level, itemStack, itemStack);
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(itemStack));
        this.entityData.set(ID_FOIL, (Object)itemStack.hasFoil());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_LOYALTY, (Object)0);
        builder.define(ID_FOIL, (Object)false);
        this.setBoundingBox(new AABB(-0.25, -0.25, -0.25, 0.25, 0.25, 0.25));
    }

    @NotNull
    public EntityDimensions getDimensions(Pose pose) {
        return EntityDimensions.fixed((float)0.5f, (float)0.5f);
    }

    public void tick() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.getOwner();
        byte i = (Byte)this.entityData.get(ID_LOYALTY);
        if (i > 0 && (this.dealtDamage || this.isNoPhysics()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.level().isClientSide && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            } else {
                this.setNoPhysics(true);
                Vec3 vec3 = entity.getEyePosition().subtract(this.position());
                this.setPosRaw(this.getX(), this.getY() + vec3.y * 0.015 * (double)i, this.getZ());
                if (this.level().isClientSide) {
                    this.yOld = this.getY();
                }
                double d = 0.05 * (double)i;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vec3.normalize().scale(d)));
                if (this.clientSideReturnSpearTickCount == 0) {
                    this.playSound(SoundEvents.TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++this.clientSideReturnSpearTickCount;
            }
        }
        super.tick();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.getOwner();
        if (entity != null && entity.isAlive()) {
            return !(entity instanceof ServerPlayer) || !entity.isSpectator();
        }
        return false;
    }

    @NotNull
    protected ItemStack getPickupItem() {
        return this.spearItem.copy();
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ObjectRegistry.SPEAR.get());
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 startVec, Vec3 endVec) {
        return this.dealtDamage ? null : super.findHitEntity(startVec, endVec);
    }

    protected void onHitEntity(EntityHitResult result) {
        ServerLevel serverLevel;
        Entity entity = result.getEntity();
        float f = 8.0f;
        Entity entity2 = this.getOwner();
        DamageSource damageSource = this.damageSources().trident((Entity)this, (Entity)(entity2 == null ? this : entity2));
        Level var7 = this.level();
        if (var7 instanceof ServerLevel) {
            serverLevel = (ServerLevel)var7;
            f = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)this.spearItem, (Entity)entity, (DamageSource)damageSource, (float)f);
        }
        this.dealtDamage = true;
        if (entity.hurt(damageSource, f)) {
            if (entity.getType() == EntityType.ENDERMAN) {
                return;
            }
            Level level = this.level();
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel, (Entity)entity, (DamageSource)damageSource, (ItemStack)this.spearItem);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.doKnockback(livingEntity, damageSource);
                this.doPostHurtEffects(livingEntity);
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        this.playSound(SoundEvents.TRIDENT_HIT, 1.0f, 1.0f);
    }

    public ItemStack getWeaponItem() {
        return this.spearItem;
    }

    protected boolean tryPickup(Player player) {
        return super.tryPickup(player) || this.isNoPhysics() && this.ownedBy((Entity)player) && player.getInventory().add(this.getPickupItem());
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.TRIDENT_HIT_GROUND;
    }

    public void playerTouch(Player player) {
        if (this.ownedBy((Entity)player) || this.getOwner() == null) {
            super.playerTouch(player);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Spear", 10)) {
            this.spearItem = ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)tag.getCompound("Spear"));
        }
        this.dealtDamage = tag.getBoolean("DealtDamage");
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(this.spearItem));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("Spear", this.spearItem.save((HolderLookup.Provider)this.level().registryAccess()));
        tag.putBoolean("DealtDamage", this.dealtDamage);
    }

    public void tickDespawn() {
        if (this.pickup != AbstractArrow.Pickup.ALLOWED || (Byte)this.entityData.get(ID_LOYALTY) <= 0) {
            super.tickDespawn();
        }
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    public boolean shouldRender(double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    private byte getLoyaltyFromItem(ItemStack itemStack) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return (byte)Mth.clamp((int)EnchantmentHelper.getTridentReturnToOwnerAcceleration((ServerLevel)serverLevel, (ItemStack)itemStack, (Entity)this), (int)0, (int)127);
        }
        return 0;
    }
}

