/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresIdentifier;
import org.jetbrains.annotations.NotNull;

public class FloatingDebrisEntity
extends Entity {
    private static final int MAX_INTERACTIONS = 3;
    private static final float DESTRUCTION_SPEED = 0.05f;
    private static final EntityDataAccessor<Boolean> IS_DESTROYING = SynchedEntityData.defineId(FloatingDebrisEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> DESTRUCTION_PROGRESS = SynchedEntityData.defineId(FloatingDebrisEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> HURT_TIME = SynchedEntityData.defineId(FloatingDebrisEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final float randomRotation;
    private int interactions = 0;
    private int lifeTicks;
    private int maxLifeTicks;

    public FloatingDebrisEntity(EntityType<? extends FloatingDebrisEntity> type, Level level) {
        super(type, level);
        Random random = new Random();
        this.setBoundingBox(this.getBoundingBox().move(0.0, 1.0, 0.0));
        this.randomRotation = random.nextFloat() * 360.0f;
        this.lifeTicks = 0;
        this.maxLifeTicks = 9600;
        if (!this.level().isClientSide) {
            this.spawnPlacementParticles();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(IS_DESTROYING, (Object)false);
        builder.define(DESTRUCTION_PROGRESS, (Object)Float.valueOf(0.0f));
        builder.define(HURT_TIME, (Object)0);
    }

    public void tick() {
        int currentHurtTime;
        super.tick();
        if (!this.level().isClientSide) {
            ++this.lifeTicks;
            if (this.lifeTicks >= this.maxLifeTicks) {
                this.remove(Entity.RemovalReason.DISCARDED);
                return;
            }
        }
        if (this.level().isClientSide && this.lifeTicks % 120 == 0) {
            this.spawnPeriodicParticles();
        }
        if ((currentHurtTime = ((Integer)this.entityData.get(HURT_TIME)).intValue()) > 0) {
            this.entityData.set(HURT_TIME, (Object)(currentHurtTime - 1));
        }
        if (!this.level().isClientSide && !this.isAboveWater()) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (((Boolean)this.entityData.get(IS_DESTROYING)).booleanValue()) {
            float currentProgress = ((Float)this.entityData.get(DESTRUCTION_PROGRESS)).floatValue();
            this.entityData.set(DESTRUCTION_PROGRESS, (Object)Float.valueOf(currentProgress += 0.05f));
            if (currentProgress >= 1.0f) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public float getRandomRotation() {
        return this.randomRotation;
    }

    private boolean isAboveWater() {
        return this.level().getBlockState(this.blockPosition().below()).getFluidState().isSource();
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.interactions = compound.getInt("Interactions");
        boolean destroying = compound.getBoolean("IsDestroying");
        float progress = compound.getFloat("DestructionProgress");
        this.entityData.set(IS_DESTROYING, (Object)destroying);
        this.entityData.set(DESTRUCTION_PROGRESS, (Object)Float.valueOf(progress));
        this.entityData.set(HURT_TIME, (Object)compound.getInt("HurtTime"));
        this.lifeTicks = compound.getInt("LifeTicks");
        this.maxLifeTicks = compound.getInt("MaxLifeTicks");
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("Interactions", this.interactions);
        compound.putBoolean("IsDestroying", ((Boolean)this.entityData.get(IS_DESTROYING)).booleanValue());
        compound.putFloat("DestructionProgress", ((Float)this.entityData.get(DESTRUCTION_PROGRESS)).floatValue());
        compound.putInt("HurtTime", ((Integer)this.entityData.get(HURT_TIME)).intValue());
        compound.putInt("LifeTicks", this.lifeTicks);
        compound.putInt("MaxLifeTicks", this.maxLifeTicks);
    }

    public void triggerHurt() {
        this.entityData.set(HURT_TIME, (Object)10);
        if (!this.level().isClientSide) {
            this.maxLifeTicks += 2400;
        }
    }

    public LootTable getLootTable(ServerLevel serverLevel) {
        return serverLevel.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LilisLuckyLuresIdentifier.identifier("gameplay/fishing_pools/floating_debris")));
    }

    public void onFishHookInteract(Player player) {
        Level level;
        if (!this.level().isClientSide && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootTable lootTable = this.getLootTable(serverLevel);
            LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)player).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)serverLevel.damageSources().generic()).create(LootContextParamSets.ENTITY);
            ObjectArrayList loot = lootTable.getRandomItems(lootParams);
            loot.forEach(arg_0 -> ((Player)player).addItem(arg_0));
            this.triggerHurt();
            ++this.interactions;
            if (this.interactions >= 3) {
                this.removeWithEffects(serverLevel);
            }
        }
    }

    public void removeWithEffects(ServerLevel serverLevel) {
        double zOffset;
        int i;
        serverLevel.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GOAT_SCREAMING_HORN_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        for (i = 0; i < 35; ++i) {
            double yOffset = serverLevel.random.nextDouble() * 15.0;
            double xOffset = 0.25 * (serverLevel.random.nextDouble() - 0.5);
            zOffset = 0.25 * (serverLevel.random.nextDouble() - 0.5);
            double velocityY = 0.1 + serverLevel.random.nextDouble() * 0.2;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SPLASH, this.getX() + xOffset + 0.5, this.getY() + yOffset, this.getZ() + zOffset + 0.5, 1, 0.0, velocityY, 0.0, 0.0);
        }
        for (i = 0; i < 18; ++i) {
            double xOffset = serverLevel.random.nextGaussian() * 0.2;
            double yOffset = serverLevel.random.nextGaussian() * 0.2;
            zOffset = serverLevel.random.nextGaussian() * 0.2;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.BUBBLE_POP, this.getX(), this.getY(), this.getZ(), 20, xOffset, yOffset, zOffset, 0.1);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY() + 1.0, this.getZ(), 10, xOffset, yOffset, zOffset, 0.1);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.CRIT, this.getX(), this.getY(), this.getZ(), 5, xOffset, yOffset, zOffset, 0.1);
        }
        this.entityData.set(IS_DESTROYING, (Object)true);
    }

    public int getHurtTime() {
        return (Integer)this.entityData.get(HURT_TIME);
    }

    public void triggerInteraction() {
        ++this.interactions;
        this.triggerHurt();
        if (this.interactions >= 3 && !this.level().isClientSide) {
            this.removeWithEffects((ServerLevel)this.level());
        }
    }

    private void spawnPlacementParticles() {
        for (int i = 0; i < 10; ++i) {
            double xOffset = this.random.nextDouble() - 0.5;
            double zOffset = this.random.nextDouble() - 0.5;
            this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() + xOffset, this.getY() + 1.9, this.getZ() + zOffset, 0.0, 0.1, 0.0);
        }
    }

    private void spawnPeriodicParticles() {
        double x = this.getX() + (this.random.nextDouble() - 0.5) * 2.0;
        double z = this.getZ() + (this.random.nextDouble() - 0.5) * 2.0;
        this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, x, this.getY() + 1.8, z, 0.0, 0.05, 0.0);
    }

    @NotNull
    public AABB getBoundingBoxForCulling() {
        return new AABB(this.getX() - 1.0, this.getY() - 1.0, this.getZ() - 1.0, this.getX() + 1.0, this.getY() + 1.0, this.getZ() + 1.0);
    }
}

