/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.satisfy.lilis_lucky_lures.core.registry.EntityTypeRegistry;
import net.satisfy.lilis_lucky_lures.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;

public class DynamiteEntity
extends ThrowableItemProjectile {
    private static final float EXPLOSION_RADIUS = 1.5f;
    private static final float DAMPING_FACTOR = 0.2f;
    private static final double MIN_VELOCITY = 0.2;
    private static final int SMOKE_DURATION = 100;
    private static final float EXTRA_DAMAGE = 2.0f;
    private int bounceCount;
    private int smokeTicksRemaining = 0;

    public DynamiteEntity(Level world, LivingEntity owner) {
        super((EntityType)EntityTypeRegistry.DYNAMITE.get(), owner, world);
    }

    public DynamiteEntity(EntityType<? extends DynamiteEntity> entityType, Level world) {
        super(entityType, world);
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ObjectRegistry.DYNAMITE.get();
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return new ClientboundAddEntityPacket((Entity)this, serverEntity);
    }

    private ParticleOptions getParticle() {
        ItemStack stack = this.getItem();
        return stack.isEmpty() ? ParticleTypes.SMOKE : new ItemParticleOption(ParticleTypes.ITEM, stack);
    }

    public void handleEntityEvent(byte event) {
        if (event == 3) {
            double speed;
            double z;
            double y;
            double x;
            double phi;
            double theta;
            int i;
            ParticleOptions itemParticle = this.getParticle();
            for (i = 0; i < 6; ++i) {
                theta = this.random.nextDouble() * 2.0 * Math.PI;
                phi = Math.acos(2.0 * this.random.nextDouble() - 1.0);
                x = Math.sin(phi) * Math.cos(theta);
                y = Math.sin(phi) * Math.sin(theta);
                z = Math.cos(phi);
                speed = 0.5;
                this.level().addParticle(itemParticle, this.getX(), this.getY(), this.getZ(), x * speed, y * speed, z * speed);
            }
            for (i = 0; i < 4; ++i) {
                theta = this.random.nextDouble() * 2.0 * Math.PI;
                phi = Math.acos(2.0 * this.random.nextDouble() - 1.0);
                x = Math.sin(phi) * Math.cos(theta);
                y = Math.sin(phi) * Math.sin(theta);
                z = Math.cos(phi);
                speed = 0.3;
                this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY(), this.getZ(), x * speed, y * speed, z * speed);
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), x * speed, y * speed, z * speed);
            }
            this.smokeTicksRemaining = 100;
        } else {
            super.handleEntityEvent(event);
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        }
        if (this.getDeltaMovement().length() < 0.2 && this.bounceCount > 0 && !this.level().isClientSide) {
            this.explode();
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
        if (this.smokeTicksRemaining > 0) {
            if (this.level().isClientSide) {
                double height = 6.0;
                for (int i = 0; i < 5; ++i) {
                    double offsetX = (this.random.nextDouble() - 0.5) * 0.5;
                    double offsetZ = (this.random.nextDouble() - 0.5) * 0.5;
                    double posY = this.getY() + height * (1.0 - (double)this.smokeTicksRemaining / 100.0) + this.random.nextDouble() * 0.2;
                    this.level().addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.getX() + offsetX, posY, this.getZ() + offsetZ, 0.0, 0.1, 0.0);
                }
            }
            --this.smokeTicksRemaining;
            if (this.smokeTicksRemaining <= 0) {
                this.discard();
            }
        }
    }

    protected void onHit(HitResult result) {
        if (this.bounceCount >= 1 || this.tickCount >= 160) {
            if (!this.level().isClientSide) {
                this.explode();
                this.level().broadcastEntityEvent((Entity)this, (byte)3);
                this.discard();
            }
        } else {
            ++this.bounceCount;
            super.onHit(result);
        }
    }

    protected void onHitBlock(BlockHitResult hit) {
        double vx = this.getDeltaMovement().x;
        double vy = this.getDeltaMovement().y;
        double vz = this.getDeltaMovement().z;
        Direction d = hit.getDirection();
        BlockPos pos = hit.getBlockPos();
        if (this.level().getBlockState(pos).blocksMotion()) {
            if (!this.level().isClientSide && this.bounceCount < 2) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WOOD_HIT, SoundSource.NEUTRAL, 1.0f, 4.0f);
            }
            if (d == Direction.EAST || d == Direction.WEST) {
                vx = -vx * (double)0.2f;
            }
            if (d == Direction.DOWN || d == Direction.UP) {
                vy = -vy * (double)0.2f;
            }
            if (d == Direction.NORTH || d == Direction.SOUTH) {
                vz = -vz * (double)0.2f;
            }
            this.setDeltaMovement(vx, vy, vz);
        }
    }

    protected void onHitEntity(EntityHitResult hit) {
        double vx = this.getDeltaMovement().x;
        double vy = this.getDeltaMovement().y;
        double vz = this.getDeltaMovement().z;
        double ax = Math.abs(vx);
        double ay = Math.abs(vy);
        double az = Math.abs(vz);
        if (ax >= ay && ax >= az) {
            vx = -vx * (double)0.2f;
        } else if (ay >= ax && ay >= az) {
            vy = -vy * (double)0.2f;
        } else {
            vz = -vz * (double)0.2f;
        }
        this.setDeltaMovement(vx, vy, vz);
    }

    public void shootFromRotation(Entity entity, float x, float y, float z, float velocity, float inaccuracy) {
        float f = -Mth.sin((float)(y * ((float)Math.PI / 180))) * Mth.cos((float)(x * ((float)Math.PI / 180)));
        float f1 = -Mth.sin((float)((x + z) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(y * ((float)Math.PI / 180))) * Mth.cos((float)(x * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, inaccuracy);
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)0.7f, 0.5, (double)0.7f));
        Vec3 v = entity.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(v.x, entity.onGround() ? 0.0 : v.y, v.z));
    }

    protected void explode() {
        boolean underwater = this.isInWater();
        float radius = underwater ? 4.5f : 1.5f;
        Level.ExplosionInteraction interaction = underwater ? Level.ExplosionInteraction.NONE : Level.ExplosionInteraction.TNT;
        this.level().explode((Entity)this, (double)((float)this.getX()), (double)((float)(this.getY(0.0625) + 0.5)), (double)((float)this.getZ()), radius, interaction);
        Vector3d center = new Vector3d(this.getX(), this.getY(0.0625) + 0.5, this.getZ());
        AABB aabb = new AABB(center.x - (double)radius, center.y - (double)radius, center.z - (double)radius, center.x + (double)radius, center.y + (double)radius, center.z + (double)radius);
        for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, aabb)) {
            if (entity == this.getOwner()) continue;
            entity.hurt(this.level().damageSources().explosion(null), 2.0f);
        }
    }
}

