/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.block.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.Team;
import net.satisfy.lilis_lucky_lures.core.block.RedstoneCoilBlock;
import net.satisfy.lilis_lucky_lures.core.registry.EntityTypeRegistry;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class RedstoneCoilBlockEntity
extends BlockEntity {
    private static final Random RANDOM = new Random();
    private BlockPos targetPos = null;
    private int beamProgress = 0;
    private int tickCounter = 0;
    private int phase = 0;
    private UUID owner = null;

    public RedstoneCoilBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.REDSTONE_COIL.get(), pos, state);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        if (this.owner != null) {
            compoundTag.putUUID("Owner", this.owner);
        }
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        if (compoundTag.hasUUID("Owner")) {
            this.owner = compoundTag.getUUID("Owner");
        }
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void setActive(boolean active) {
        if (this.level != null) {
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)RedstoneCoilBlock.ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RedstoneCoilBlockEntity be) {
        ServerLevel serverLevel;
        block33: {
            block32: {
                if (!(level instanceof ServerLevel)) break block32;
                serverLevel = (ServerLevel)level;
                if (((Boolean)state.getValue((Property)RedstoneCoilBlock.ACTIVE)).booleanValue()) break block33;
            }
            return;
        }
        ++be.tickCounter;
        if (be.tickCounter >= 200) {
            be.tickCounter = 0;
            int range = Math.min(32, Math.max(3, serverLevel.getBestNeighborSignal(pos)));
            AABB box = new AABB(pos).inflate((double)range);
            List entities = serverLevel.getEntitiesOfClass(LivingEntity.class, box, LivingEntity::isAlive);
            RedstoneCoilBlock.RedstoneCoilTarget targetMode = (RedstoneCoilBlock.RedstoneCoilTarget)((Object)state.getValue(RedstoneCoilBlock.TARGET));
            ArrayList<LivingEntity> filtered = new ArrayList<LivingEntity>();
            switch (targetMode) {
                case NONE: {
                    break;
                }
                case FISHES: {
                    for (LivingEntity entity : entities) {
                        if (!entity.isInWater()) continue;
                        filtered.add(entity);
                    }
                    break;
                }
                case PLAYER: {
                    Iterator ownerPlayer = be.owner != null ? serverLevel.getPlayerByUUID(be.owner) : null;
                    for (LivingEntity entity : entities) {
                        Player p;
                        if (!(entity instanceof Player) || (p = (Player)entity).isCreative() || ownerPlayer != null && (p.getUUID().equals(ownerPlayer.getUUID()) || ownerPlayer.getTeam() != null && p.getTeam() != null && ownerPlayer.getTeam().isAlliedTo((Team)p.getTeam()))) continue;
                        filtered.add(entity);
                    }
                    break;
                }
                case MONSTER: {
                    for (LivingEntity entity : entities) {
                        if (entity.getType().getCategory() != MobCategory.MONSTER) continue;
                        filtered.add(entity);
                    }
                    break;
                }
            }
            if (!filtered.isEmpty()) {
                LivingEntity target = (LivingEntity)filtered.get(0);
                be.targetPos = target.blockPosition();
                be.beamProgress = 0;
                be.phase = 1;
                serverLevel.playSound(null, pos, SoundEvents.EVOKER_PREPARE_ATTACK, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (be.phase == 1 && be.beamProgress < 30) {
            double radius = (1.0 - (double)be.beamProgress / 30.0) * 2.0;
            for (int i = 0; i < 5; ++i) {
                double angle = serverLevel.random.nextDouble() * Math.PI * 2.0;
                double x = (double)pos.getX() + 0.5 + radius * Math.cos(angle);
                double y = (double)pos.getY() + 1.0 + serverLevel.random.nextDouble();
                double z = (double)pos.getZ() + 0.5 + radius * Math.sin(angle);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            ++be.beamProgress;
            if (be.beamProgress >= 30) {
                be.beamProgress = 0;
                be.phase = 2;
            }
        }
        if (be.phase == 2 && be.beamProgress < 20 && be.targetPos != null) {
            if (be.beamProgress == 0) {
                serverLevel.playSound(null, pos, SoundEvents.GHAST_SHOOT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            ++be.beamProgress;
            double progress = (double)be.beamProgress / 20.0;
            Vector3d start = new Vector3d((double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5);
            Vector3d end = new Vector3d((double)be.targetPos.getX() + 0.5, (double)be.targetPos.getY() + 0.5, (double)be.targetPos.getZ() + 0.5);
            Vector3d dir = new Vector3d((Vector3dc)end).sub((Vector3dc)start);
            Vector3d current = new Vector3d((Vector3dc)dir).mul(progress).add((Vector3dc)start);
            Vector3d arbitrary = new Vector3d(0.0, 1.0, 0.0);
            if (Math.abs(dir.dot((Vector3dc)arbitrary)) > 0.99) {
                arbitrary.set(1.0, 0.0, 0.0);
            }
            Vector3d perp = new Vector3d();
            dir.cross((Vector3dc)arbitrary, perp).normalize();
            double wave = Math.sin(progress * Math.PI * 4.0) * 0.1;
            perp.mul(wave);
            current.add((Vector3dc)perp);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, current.x, current.y, current.z, 1, 0.0, 0.0, 0.0, 0.0);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, current.x, current.y, current.z, 1, 0.0, 0.0, 0.0, 0.0);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, current.x, current.y, current.z, 1, 0.0, 0.0, 0.0, 0.0);
            if (be.beamProgress >= 20) {
                List targets = serverLevel.getEntitiesOfClass(LivingEntity.class, new AABB(be.targetPos).inflate(1.0), LivingEntity::isAlive);
                if (!targets.isEmpty()) {
                    Player player;
                    LivingEntity livingTarget = (LivingEntity)targets.get(0);
                    if (livingTarget instanceof Player && (player = (Player)livingTarget).isBlocking()) {
                        boolean offShield;
                        boolean mainShield = !player.getMainHandItem().isEmpty() && player.getMainHandItem().getItem() instanceof ShieldItem;
                        boolean bl = offShield = !player.getOffhandItem().isEmpty() && player.getOffhandItem().getItem() instanceof ShieldItem;
                        if (mainShield || offShield) {
                            Vector3d shieldPos;
                            InteractionHand hand;
                            ItemStack shieldStack;
                            if (mainShield) {
                                shieldStack = player.getMainHandItem();
                                hand = InteractionHand.MAIN_HAND;
                            } else {
                                shieldStack = player.getOffhandItem();
                                hand = InteractionHand.OFF_HAND;
                            }
                            int shieldDamage = serverLevel.random.nextInt(10) + 4;
                            shieldStack.hurtAndBreak(shieldDamage, (LivingEntity)player, player.getEquipmentSlotForItem(shieldStack));
                            Vector3d look = new Vector3d(player.getLookAngle().x, player.getLookAngle().y, player.getLookAngle().z);
                            Vector3d right = new Vector3d();
                            new Vector3d(0.0, 1.0, 0.0).cross((Vector3dc)look, right).normalize();
                            if (hand == InteractionHand.MAIN_HAND) {
                                shieldPos = new Vector3d(player.getX(), player.getY() + (double)player.getEyeHeight() - 0.5, player.getZ());
                                shieldPos.add((Vector3dc)look.mul(0.3)).add((Vector3dc)right.mul(0.4));
                            } else {
                                shieldPos = new Vector3d(player.getX(), player.getY() + (double)player.getEyeHeight() - 0.5, player.getZ());
                                shieldPos.add((Vector3dc)look.mul(0.3)).sub((Vector3dc)right.mul(0.4));
                            }
                            int flashCount = serverLevel.random.nextInt(2) + 2;
                            for (int i = 0; i < flashCount; ++i) {
                                double flashX = shieldPos.x + (serverLevel.random.nextDouble() - 0.5) * 0.2;
                                double flashY = shieldPos.y + (serverLevel.random.nextDouble() - 0.5) * 0.2;
                                double flashZ = shieldPos.z + (serverLevel.random.nextDouble() - 0.5) * 0.2;
                                serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLASH, flashX, flashY, flashZ, 1, 0.0, 0.0, 0.0, 0.0);
                            }
                            for (LivingEntity entity : serverLevel.getEntitiesOfClass(LivingEntity.class, new AABB(shieldPos.x, shieldPos.y, shieldPos.z, shieldPos.x, shieldPos.y, shieldPos.z).inflate(10.0), LivingEntity::isAlive)) {
                                entity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 60, 0));
                            }
                        } else {
                            RedstoneCoilBlockEntity.applyDamage(livingTarget, serverLevel, be);
                        }
                    } else {
                        RedstoneCoilBlockEntity.applyDamage(livingTarget, serverLevel, be);
                    }
                }
                be.phase = 0;
                be.targetPos = null;
                be.beamProgress = 0;
            }
        }
    }

    private static void applyDamage(LivingEntity livingTarget, ServerLevel serverLevel, RedstoneCoilBlockEntity be) {
        float damage = 10.0f;
        if (livingTarget.isInWater()) {
            damage *= 1.65f;
        }
        boolean hasIronArmor = false;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ArmorItem armorItem;
            Item item;
            ItemStack armorStack;
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || (armorStack = livingTarget.getItemBySlot(slot)).isEmpty() || !((item = armorStack.getItem()) instanceof ArmorItem) || (armorItem = (ArmorItem)item).getMaterial() != ArmorMaterials.IRON) continue;
            hasIronArmor = true;
            int armorDamage = serverLevel.random.nextInt(5) + 3;
            armorStack.hurtAndBreak(armorDamage, livingTarget, slot);
        }
        if (hasIronArmor) {
            damage *= 1.12f;
        }
        livingTarget.hurt(serverLevel.damageSources().magic(), damage);
        livingTarget.igniteForTicks(5);
        RedstoneCoilBlockEntity.setFireAround(serverLevel, be.targetPos);
        RedstoneCoilBlockEntity.spawnImpactParticles(serverLevel, be.targetPos);
    }

    private static void setFireAround(ServerLevel level, BlockPos center) {
        for (int x = center.getX() - 3; x <= center.getX() + 3; ++x) {
            for (int y = center.getY() - 3; y <= center.getY() + 3; ++y) {
                for (int z = center.getZ() - 3; z <= center.getZ() + 3; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    BlockPos abovePos = currentPos.above();
                    if (level.getBlockState(currentPos).isAir() || !level.isEmptyBlock(abovePos) || !(RANDOM.nextDouble() < 0.05)) continue;
                    level.setBlock(abovePos, Blocks.FIRE.defaultBlockState(), 3);
                }
            }
        }
    }

    private static void spawnImpactParticles(ServerLevel level, BlockPos pos) {
        for (int i = 0; i < 40; ++i) {
            Vector3d vec = new Vector3d(level.random.nextDouble() * 2.0 - 1.0, level.random.nextDouble() * 2.0 - 1.0, level.random.nextDouble() * 2.0 - 1.0);
            if (vec.lengthSquared() == 0.0) continue;
            vec.normalize().mul(level.random.nextDouble() * 1.5 + 0.5);
            double particleX = (double)pos.getX() + 0.5;
            double particleY = (double)pos.getY() + 0.5;
            double particleZ = (double)pos.getZ() + 0.5;
            level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, particleX, particleY, particleZ, 0, vec.x, vec.y, vec.z, 0.2);
            level.sendParticles((ParticleOptions)ParticleTypes.FLAME, particleX, particleY, particleZ, 0, vec.x * 1.2, vec.y * 1.2, vec.z * 1.2, 0.1);
        }
    }
}

