/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.block.entity;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.lilis_lucky_lures.core.block.FishTrophyFrameBlock;
import net.satisfy.lilis_lucky_lures.core.registry.EntityTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class FishTrophyFrameBlockEntity
extends BlockEntity
implements Clearable {
    private ItemStack displayedItem = ItemStack.EMPTY;

    public FishTrophyFrameBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.FISH_TROPHY_FRAME.get(), pos, state);
    }

    public ItemStack getDisplayedItem() {
        return this.displayedItem;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.displayedItem = tag.contains("DisplayedItem", 10) ? ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("DisplayedItem")) : ItemStack.EMPTY;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (!this.displayedItem.isEmpty()) {
            tag.put("DisplayedItem", this.displayedItem.save(provider, (Tag)new CompoundTag()));
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        if (!this.displayedItem.isEmpty()) {
            tag.put("DisplayedItem", this.displayedItem.save(provider, (Tag)new CompoundTag()));
        }
        return tag;
    }

    public boolean setDisplayedItem(ItemStack stack) {
        if (!this.displayedItem.isEmpty()) {
            return false;
        }
        this.displayedItem = stack.copyWithCount(1);
        this.updateBlockState(true);
        return true;
    }

    public void removeDisplayedItem(int count) {
        if (!this.displayedItem.isEmpty()) {
            this.displayedItem.shrink(count);
            if (this.displayedItem.isEmpty()) {
                this.displayedItem = ItemStack.EMPTY;
                this.updateBlockState(false);
            } else {
                this.markUpdated();
            }
        }
    }

    public void dropContents() {
        if (!this.displayedItem.isEmpty()) {
            assert (this.level != null);
            ItemEntity e = new ItemEntity(this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), this.displayedItem);
            this.level.addFreshEntity((Entity)e);
            this.displayedItem = ItemStack.EMPTY;
            this.updateBlockState(false);
        } else {
            this.markUpdated();
        }
    }

    private void updateBlockState(boolean hasItem) {
        if (this.level != null) {
            BlockState s = this.level.getBlockState(this.worldPosition);
            if (s.hasProperty((Property)FishTrophyFrameBlock.HAS_ITEM)) {
                this.level.setBlock(this.worldPosition, (BlockState)s.setValue((Property)FishTrophyFrameBlock.HAS_ITEM, (Comparable)Boolean.valueOf(hasItem)), 3);
            }
            this.markUpdated();
        }
    }

    private void markUpdated() {
        this.setChanged();
        Objects.requireNonNull(this.getLevel()).sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void clearContent() {
        this.displayedItem = ItemStack.EMPTY;
        this.updateBlockState(false);
    }
}

