/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.block.entity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.lilis_lucky_lures.core.block.FishTrapBlock;
import net.satisfy.lilis_lucky_lures.core.recipe.FishTrapRecipe;
import net.satisfy.lilis_lucky_lures.core.registry.EntityTypeRegistry;
import net.satisfy.lilis_lucky_lures.core.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class FishTrapBlockEntity
extends BlockEntity
implements WorldlyContainer,
Clearable {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private int timer = 0;
    private int duration = 0;
    private boolean processing = false;
    private FishTrapRecipe recipe;

    public FishTrapBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.FISH_TRAP.get(), pos, state);
    }

    public void tick() {
        if (this.level != null && !this.level.isClientSide) {
            ItemStack inputItem = (ItemStack)this.inventory.get(0);
            if (this.recipe == null && !inputItem.isEmpty()) {
                FishTrapBlockEntity.getRecipe(this.level, inputItem).ifPresent(currentRecipe -> {
                    this.recipe = currentRecipe;
                });
            }
            if (this.recipe == null || inputItem.isEmpty()) {
                this.processing = false;
                this.timer = 0;
                return;
            }
            if (this.processing) {
                ++this.timer;
                if (this.timer >= this.duration) {
                    this.processing = false;
                    this.timer = 0;
                    ItemStack stack = (ItemStack)this.inventory.get(0);
                    if (!stack.isEmpty()) {
                        stack.shrink(1);
                        if (stack.getCount() <= 0) {
                            this.inventory.set(0, (Object)ItemStack.EMPTY);
                        }
                    }
                    this.addCatchToOutput();
                    this.recipe = null;
                    this.setChanged();
                }
            } else if (this.recipe.getBaitItem().test(inputItem)) {
                this.processing = true;
                this.duration = this.recipe.getRandomDuration();
            }
            this.updateBlockState();
        }
    }

    private void addCatchToOutput() {
        ItemStack output = this.recipe.getCatchItem().copy();
        output.setCount(this.recipe.getCatchCount());
        ItemStack existingOutput = (ItemStack)this.inventory.get(1);
        if (existingOutput.isEmpty()) {
            this.inventory.set(1, (Object)output);
        } else if (ItemStack.isSameItemSameComponents((ItemStack)existingOutput, (ItemStack)output)) {
            existingOutput.grow(output.getCount());
            this.inventory.set(1, (Object)existingOutput);
        }
        this.updateBlockState();
    }

    private void updateBlockState() {
        if (this.level != null) {
            boolean isFull = !((ItemStack)this.inventory.get(1)).isEmpty();
            boolean hasBait = !((ItemStack)this.inventory.get(0)).isEmpty();
            BlockState state = this.level.getBlockState(this.worldPosition);
            Block block = state.getBlock();
            if (block instanceof FishTrapBlock) {
                FishTrapBlock fishTrapBlock = (FishTrapBlock)block;
                fishTrapBlock.updateBlockState(this.level, this.worldPosition, isFull, hasBait);
            }
        }
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.inventory, (HolderLookup.Provider)provider);
        this.timer = compoundTag.getInt("Timer");
        this.duration = compoundTag.getInt("Duration");
        this.processing = compoundTag.getBoolean("Processing");
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.inventory, (HolderLookup.Provider)provider);
        compoundTag.putInt("Timer", this.timer);
        compoundTag.putInt("Duration", this.duration);
        compoundTag.putBoolean("Processing", this.processing);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)provider);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public boolean isEmpty() {
        return this.inventory.stream().allMatch(ItemStack::isEmpty);
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack removed = ContainerHelper.removeItem(this.inventory, (int)slot, (int)amount);
        this.setChanged();
        this.updateBlockState();
        return removed;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack removed = ContainerHelper.takeItem(this.inventory, (int)slot);
        this.setChanged();
        this.updateBlockState();
        return removed;
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        this.setChanged();
        this.updateBlockState();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.inventory.clear();
        this.recipe = null;
        this.setChanged();
        this.updateBlockState();
    }

    public int @NotNull [] getSlotsForFace(Direction direction) {
        return new int[]{0, 1};
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, Direction direction) {
        return slot == 0 && this.canPlaceItem(slot, stack);
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction direction) {
        return slot == 1;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (slot == 0) {
            return this.level != null && FishTrapBlockEntity.getRecipe(this.level, stack).isPresent();
        }
        return false;
    }

    public static Optional<FishTrapRecipe> getRecipe(Level level, ItemStack itemStack) {
        return level.getRecipeManager().getAllRecipesFor((RecipeType)RecipeTypeRegistry.FISH_TRAP_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).filter(r -> r.getBaitItem().test(itemStack)).findFirst();
    }
}

