/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.block;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.lilis_lucky_lures.core.block.entity.RedstoneCoilBlockEntity;
import net.satisfy.lilis_lucky_lures.core.registry.EntityTypeRegistry;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class RedstoneCoilBlock
extends BaseEntityBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    public static final EnumProperty<DoubleBlockHalf> HALF = EnumProperty.create((String)"half", DoubleBlockHalf.class);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<RedstoneCoilTarget> TARGET = EnumProperty.create((String)"target", RedstoneCoilTarget.class);
    private static final VoxelShape TOP_SHAPE;
    private static final VoxelShape BOTTOM_SHAPE;
    private static final Map<Direction, VoxelShape> TOP_SHAPES;
    private static final Map<Direction, VoxelShape> BOTTOM_SHAPES;
    private static final Random RANDOM;
    public static final MapCodec<RedstoneCoilBlock> CODEC;

    public RedstoneCoilBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue(TARGET, (Comparable)((Object)RedstoneCoilTarget.NONE)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.isClientSide) {
            if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
                BlockPos posAbove;
                BlockState stateAbove;
                boolean powered = level.hasNeighborSignal(pos);
                if ((Boolean)state.getValue((Property)ACTIVE) != powered) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(powered)), 3);
                    BlockEntity be = level.getBlockEntity(pos);
                    if (be instanceof RedstoneCoilBlockEntity) {
                        RedstoneCoilBlockEntity coil = (RedstoneCoilBlockEntity)be;
                        coil.setActive(powered);
                    }
                }
                if ((stateAbove = level.getBlockState(posAbove = pos.above())).getBlock() instanceof RedstoneCoilBlock && stateAbove.getValue(HALF) == DoubleBlockHalf.UPPER && (Boolean)stateAbove.getValue((Property)ACTIVE) != powered) {
                    level.setBlock(posAbove, (BlockState)stateAbove.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(powered)), 3);
                    BlockEntity beAbove = level.getBlockEntity(posAbove);
                    if (beAbove instanceof RedstoneCoilBlockEntity) {
                        RedstoneCoilBlockEntity coilAbove = (RedstoneCoilBlockEntity)beAbove;
                        coilAbove.setActive(powered);
                    }
                }
            } else {
                BlockPos posBelow = pos.below();
                BlockState stateBelow = level.getBlockState(posBelow);
                if (stateBelow.getBlock() instanceof RedstoneCoilBlock && stateBelow.getValue(HALF) == DoubleBlockHalf.LOWER) {
                    boolean bottomActive = (Boolean)stateBelow.getValue((Property)ACTIVE);
                    if ((Boolean)state.getValue((Property)ACTIVE) != bottomActive) {
                        level.setBlock(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(bottomActive)), 3);
                        BlockEntity be = level.getBlockEntity(pos);
                        if (be instanceof RedstoneCoilBlockEntity) {
                            RedstoneCoilBlockEntity coil = (RedstoneCoilBlockEntity)be;
                            coil.setActive(bottomActive);
                        }
                    }
                }
            }
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos posAbove = ctx.getClickedPos().above();
        Level level = ctx.getLevel();
        if (!level.getBlockState(posAbove).canBeReplaced(ctx)) {
            return null;
        }
        Direction facing = ctx.getHorizontalDirection().getOpposite();
        BlockState baseState = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue(TARGET, (Comparable)((Object)RedstoneCoilTarget.NONE));
        BlockState upperState = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue(TARGET, (Comparable)((Object)RedstoneCoilTarget.NONE));
        level.setBlock(posAbove, upperState, 3);
        return baseState;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockPos otherPos;
        BlockState otherState;
        if (!state.is(newState.getBlock()) && (otherState = level.getBlockState(otherPos = state.getValue(HALF) == DoubleBlockHalf.LOWER ? pos.above() : pos.below())).is((Block)this)) {
            level.setBlock(otherPos, Blocks.AIR.defaultBlockState(), 35);
            if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
                Block.dropResources((BlockState)otherState, (Level)level, (BlockPos)pos.below());
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RedstoneCoilBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return RedstoneCoilBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.REDSTONE_COIL.get()), RedstoneCoilBlockEntity::tick);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE, FACING, HALF, TARGET});
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)ACTIVE)).booleanValue() && state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            double centerX = (double)pos.getX() + 0.5;
            double centerY = (double)pos.getY() + 1.5;
            double centerZ = (double)pos.getZ() + 0.5;
            DustParticleOptions redDust = new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 1.0f);
            for (int i = 0; i < 2; ++i) {
                double offsetX = (RANDOM.nextDouble() - 0.5) * 0.6;
                double offsetY = RANDOM.nextDouble() * 0.3;
                double offsetZ = (RANDOM.nextDouble() - 0.5) * 0.6;
                level.addParticle((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, centerX + offsetX, centerY + offsetY, centerZ + offsetZ, 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)redDust, centerX + offsetX, centerY + offsetY, centerZ + offsetZ, 0.0, 0.0, 0.0);
            }
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos basePos = state.getValue(HALF) == DoubleBlockHalf.UPPER ? pos.below() : pos;
        BlockState baseState = level.getBlockState(basePos);
        if (!(baseState.getBlock() instanceof RedstoneCoilBlock)) {
            return InteractionResult.PASS;
        }
        RedstoneCoilTarget current = (RedstoneCoilTarget)((Object)baseState.getValue(TARGET));
        RedstoneCoilTarget next = switch (current.ordinal()) {
            case 0 -> RedstoneCoilTarget.FISHES;
            case 1 -> RedstoneCoilTarget.PLAYER;
            case 2 -> RedstoneCoilTarget.MONSTER;
            default -> RedstoneCoilTarget.NONE;
        };
        level.setBlock(basePos, (BlockState)baseState.setValue(TARGET, (Comparable)((Object)next)), 3);
        return InteractionResult.CONSUME;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof RedstoneCoilBlockEntity) {
                RedstoneCoilBlockEntity coil = (RedstoneCoilBlockEntity)be;
                coil.setOwner(player.getUUID());
            }
        }
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return state.getValue(HALF) == DoubleBlockHalf.UPPER ? TOP_SHAPES.get(state.getValue((Property)FACING)) : BOTTOM_SHAPES.get(state.getValue((Property)FACING));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        Style defaultStyle = Style.EMPTY.withColor(TextColor.fromRgb((int)5415884));
        Style actionStyle = Style.EMPTY.withColor(TextColor.fromRgb((int)16772275));
        Style noteStyle = Style.EMPTY.withColor(TextColor.fromRgb((int)0xDAFFFF));
        if (!Screen.hasShiftDown()) {
            list.add((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.block.shift_to_show_more").setStyle(actionStyle).append((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.block.information").setStyle(defaultStyle)));
        } else {
            list.add((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.block.description.defense").setStyle(defaultStyle));
            list.add((Component)Component.empty());
            list.add((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.block.right_click_to_switch").setStyle(actionStyle).append((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.block.modes").setStyle(defaultStyle)));
            list.add((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.block.mode.none").setStyle(noteStyle).append((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.block.mode.none.description").setStyle(defaultStyle)));
            list.add((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.block.mode.player").setStyle(noteStyle).append((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.block.mode.player.description").setStyle(defaultStyle)));
            list.add((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.block.mode.fishes").setStyle(noteStyle).append((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.block.mode.fishes.description").setStyle(defaultStyle)));
            list.add((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.block.mode.monster").setStyle(noteStyle).append((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.block.mode.monster.description").setStyle(defaultStyle)));
            list.add((Component)Component.empty());
            list.add((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.block.note").setStyle(noteStyle).append((Component)Component.translatable((String)"tooltip.lilis_lucky_lures.block.note.description").setStyle(defaultStyle)));
        }
    }

    static {
        TOP_SHAPES = new HashMap<Direction, VoxelShape>();
        BOTTOM_SHAPES = new HashMap<Direction, VoxelShape>();
        RANDOM = new Random();
        CODEC = RedstoneCoilBlock.simpleCodec(RedstoneCoilBlock::new);
        VoxelShape shape = Shapes.box((double)0.4375, (double)0.0, (double)0.4375, (double)0.5625, (double)0.875, (double)0.5625);
        TOP_SHAPE = shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.5, (double)0.1875, (double)0.8125, (double)0.75, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.box((double)0.4375, (double)0.875, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.875, (double)0.875, (double)0.875, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.875, (double)0.875), (BooleanOp)BooleanOp.OR);
        BOTTOM_SHAPE = shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.25, (double)0.0625, (double)0.75, (double)0.75, (double)0.125), (BooleanOp)BooleanOp.OR);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            TOP_SHAPES.put(direction, LilisLuckyLuresUtil.rotateShape(Direction.NORTH, direction, TOP_SHAPE));
            BOTTOM_SHAPES.put(direction, LilisLuckyLuresUtil.rotateShape(Direction.NORTH, direction, BOTTOM_SHAPE));
        }
    }

    public static enum RedstoneCoilTarget implements StringRepresentable
    {
        NONE("none"),
        FISHES("fishes"),
        PLAYER("player"),
        MONSTER("monster");

        private final String name;

        private RedstoneCoilTarget(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

