/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.lilis_lucky_lures.core.block.entity.HangingFrameBlockEntity;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HangingFrameBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<DoubleBlockHalf> HALF = EnumProperty.create((String)"half", DoubleBlockHalf.class);
    private static final VoxelShape TOP_SHAPE = Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.empty(), (VoxelShape)Shapes.box((double)0.875, (double)0.0, (double)0.4375, (double)1.0, (double)0.875, (double)0.5625), (BooleanOp)BooleanOp.OR), (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.4375, (double)0.125, (double)0.875, (double)0.5625), (BooleanOp)BooleanOp.OR), (VoxelShape)Shapes.box((double)0.0, (double)0.875, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625), (BooleanOp)BooleanOp.OR), (VoxelShape)Shapes.box((double)0.125, (double)0.625, (double)0.4375, (double)0.875, (double)0.875, (double)0.5625), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape BOTTOM_SHAPE = Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.empty(), (VoxelShape)Shapes.box((double)0.0, (double)0.125, (double)0.4375, (double)0.125, (double)0.625, (double)0.5625), (BooleanOp)BooleanOp.OR), (VoxelShape)Shapes.box((double)0.875, (double)0.125, (double)0.4375, (double)1.0, (double)0.625, (double)0.5625), (BooleanOp)BooleanOp.OR), (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.3125, (double)0.125, (double)0.125, (double)0.6875), (BooleanOp)BooleanOp.OR), (VoxelShape)Shapes.box((double)0.875, (double)0.0, (double)0.3125, (double)1.0, (double)0.125, (double)0.6875), (BooleanOp)BooleanOp.OR), (VoxelShape)Shapes.box((double)0.0, (double)0.625, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625), (BooleanOp)BooleanOp.OR);
    private static final Map<Direction, VoxelShape> TOP_SHAPES = new HashMap<Direction, VoxelShape>();
    private static final Map<Direction, VoxelShape> BOTTOM_SHAPES = new HashMap<Direction, VoxelShape>();

    public HangingFrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HALF});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos posAbove = ctx.getClickedPos().above();
        Level level = ctx.getLevel();
        if (!level.getBlockState(posAbove).canBeReplaced(ctx)) {
            return null;
        }
        BlockState baseState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER);
        level.setBlock(posAbove, (BlockState)baseState.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        return baseState;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockPos otherPos;
            BlockState otherState;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof HangingFrameBlockEntity) {
                HangingFrameBlockEntity shelfBlockEntity = (HangingFrameBlockEntity)blockEntity;
                for (ItemStack stack : shelfBlockEntity.getInventory()) {
                    if (stack.isEmpty()) continue;
                    Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
                }
                level.removeBlockEntity(pos);
            }
            if ((otherState = level.getBlockState(otherPos = state.getValue(HALF) == DoubleBlockHalf.LOWER ? pos.above() : pos.below())).is((Block)this)) {
                level.setBlock(otherPos, Blocks.AIR.defaultBlockState(), 35);
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        if (direction == Direction.DOWN && half == DoubleBlockHalf.UPPER && neighborState.getBlock() != this) {
            return Blocks.AIR.defaultBlockState();
        }
        if (direction == Direction.UP && half == DoubleBlockHalf.LOWER && neighborState.getBlock() != this) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return state.getValue(HALF) == DoubleBlockHalf.UPPER ? TOP_SHAPES.get(state.getValue((Property)FACING)) : BOTTOM_SHAPES.get(state.getValue((Property)FACING));
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new HangingFrameBlockEntity(pos, state, this.size());
    }

    public int size() {
        return 3;
    }

    protected ItemInteractionResult useItemOn(ItemStack item, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof HangingFrameBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        HangingFrameBlockEntity shelfBlockEntity = (HangingFrameBlockEntity)blockEntity;
        Optional<Tuple<Float, Float>> optional = LilisLuckyLuresUtil.getRelativeHitCoordinatesForBlockFace(hit, (Direction)state.getValue((Property)FACING), new Direction[]{Direction.DOWN, Direction.UP});
        if (optional.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        int i = 2 - (int)(((Float)optional.get().getA()).floatValue() * 3.0f);
        if (i < 0 || i >= shelfBlockEntity.getInventory().size()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!((ItemStack)shelfBlockEntity.getInventory().get(i)).isEmpty()) {
            if (!world.isClientSide) {
                ItemStack itemStack = shelfBlockEntity.removeStack(i);
                world.playSound(null, pos, SoundEvents.WOOL_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.getInventory().add(itemStack)) {
                    player.drop(itemStack, false);
                }
                world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        ItemStack stack = player.getItemInHand(hand);
        if (!stack.isEmpty() && stack.is(ItemTags.FISHES)) {
            if (!world.isClientSide) {
                shelfBlockEntity.setStack(i, stack.split(1));
                world.playSound(null, pos, SoundEvents.WOOL_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (player.isCreative()) {
                    stack.grow(1);
                }
                world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return ItemInteractionResult.CONSUME;
    }

    static {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            TOP_SHAPES.put(direction, LilisLuckyLuresUtil.rotateShape(Direction.NORTH, direction, TOP_SHAPE));
            BOTTOM_SHAPES.put(direction, LilisLuckyLuresUtil.rotateShape(Direction.NORTH, direction, BOTTOM_SHAPE));
        }
    }
}

