/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.lilis_lucky_lures.core.block.FishNetFenceBlock;
import net.satisfy.lilis_lucky_lures.core.block.entity.FishTrapBlockEntity;
import net.satisfy.lilis_lucky_lures.core.registry.EntityTypeRegistry;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishTrapBlock
extends BaseEntityBlock {
    public static final BooleanProperty FULL = BooleanProperty.create((String)"full");
    public static final BooleanProperty HAS_BAIT = BooleanProperty.create((String)"has_bait");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty HANGING = BooleanProperty.create((String)"hanging");
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final TagKey<Block> ROPES = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)LilisLuckyLuresIdentifier.identifier("ropes"));
    private static final VoxelShape SHAPE_NORMAL = Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.625, (double)0.9375);
    private static final VoxelShape SHAPE_HANGING = Shapes.box((double)0.0625, (double)0.125, (double)0.0625, (double)0.9375, (double)0.75, (double)0.9375);
    public static final MapCodec<FishTrapBlock> CODEC = FishTrapBlock.simpleCodec(FishTrapBlock::new);

    public FishTrapBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FULL, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_BAIT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)HANGING, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FULL, HAS_BAIT, WATERLOGGED, HANGING, FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        boolean hanging = this.isHanging((LevelAccessor)level, pos.above());
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER))).setValue((Property)HANGING, (Comparable)Boolean.valueOf(hanging));
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.UP) {
            boolean hanging = this.isHanging(level, pos.above());
            return (BlockState)state.setValue((Property)HANGING, (Comparable)Boolean.valueOf(hanging));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (fromPos.equals((Object)pos.above())) {
            boolean hanging = this.isHanging((LevelAccessor)level, pos.above());
            level.setBlock(pos, (BlockState)state.setValue((Property)HANGING, (Comparable)Boolean.valueOf(hanging)), 3);
        }
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
    }

    private boolean isHanging(LevelAccessor level, BlockPos pos) {
        BlockState aboveState = level.getBlockState(pos);
        return aboveState.is(ROPES) || aboveState.getBlock() instanceof FishNetFenceBlock;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, @NotNull CollisionContext context) {
        return (Boolean)state.getValue((Property)HANGING) != false ? SHAPE_HANGING : SHAPE_NORMAL;
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FishTrapBlockEntity(pos, state);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hand != InteractionHand.MAIN_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof FishTrapBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        FishTrapBlockEntity fishTrap = (FishTrapBlockEntity)be;
        ItemStack inHand = player.getItemInHand(hand);
        if (!inHand.isEmpty()) {
            if (!level.isClientSide && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && fishTrap.getItem(0).isEmpty()) {
                ItemStack one = inHand.copy();
                one.setCount(1);
                fishTrap.setItem(0, one);
                if (!player.getAbilities().instabuild) {
                    inHand.shrink(1);
                }
                fishTrap.setChanged();
                level.blockEntityChanged(pos);
                this.updateBlockState(level, pos, !fishTrap.getItem(1).isEmpty(), !fishTrap.getItem(0).isEmpty());
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.CONSUME;
        }
        if (!level.isClientSide) {
            ItemStack output = fishTrap.getItem(1);
            if (!output.isEmpty()) {
                int n = output.getCount();
                ItemStack give = output.copy();
                if (!player.addItem(give)) {
                    ItemEntity e = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), give);
                    level.addFreshEntity((Entity)e);
                }
                fishTrap.removeItem(1, n);
                fishTrap.setChanged();
                level.blockEntityChanged(pos);
                this.updateBlockState(level, pos, !fishTrap.getItem(1).isEmpty(), !fishTrap.getItem(0).isEmpty());
                return ItemInteractionResult.SUCCESS;
            }
            ItemStack bait = fishTrap.getItem(0);
            if (!bait.isEmpty()) {
                int n = bait.getCount();
                ItemStack give = bait.copy();
                if (!player.addItem(give)) {
                    ItemEntity e = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), give);
                    level.addFreshEntity((Entity)e);
                }
                fishTrap.removeItem(0, n);
                fishTrap.setChanged();
                level.blockEntityChanged(pos);
                this.updateBlockState(level, pos, !fishTrap.getItem(1).isEmpty(), !fishTrap.getItem(0).isEmpty());
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : FishTrapBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.FISH_TRAP.get()), (lvl, pos, blkState, blockEntity) -> blockEntity.tick());
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (((Boolean)state.getValue((Property)FULL)).booleanValue() && random.nextFloat() < 0.1f) {
            double x = (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 0.5;
            double y = (double)pos.getY() + 0.7 + random.nextDouble() * 0.3;
            double z = (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 0.5;
            level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, x, y, z, 0.0, 0.02, 0.0);
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (level.isClientSide && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            int particleCount = 10;
            double centerX = (double)pos.getX() + 0.5;
            double centerZ = (double)pos.getZ() + 0.5;
            double centerY = (double)pos.getY() + 0.1;
            double velocity = 0.05;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.PI * 2 / (double)particleCount * (double)i;
                double radius = 0.15;
                for (int j = 0; j < 3; ++j) {
                    double x = centerX + radius * Math.cos(angle);
                    double z = centerZ + radius * Math.sin(angle);
                    double y = centerY + (double)j * 0.1;
                    double velX = Math.cos(angle) * velocity;
                    double velZ = Math.sin(angle) * velocity;
                    double velY = 0.02 + (double)j * 0.01;
                    level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, x, y, z, velX, velY, velZ);
                    radius += 0.4;
                }
            }
        }
    }

    public void updateBlockState(Level level, BlockPos pos, boolean full, boolean hasBait) {
        BlockState newState;
        BlockState state = level.getBlockState(pos);
        if (!state.equals(newState = (BlockState)((BlockState)state.setValue((Property)FULL, (Comparable)Boolean.valueOf(full))).setValue((Property)HAS_BAIT, (Comparable)Boolean.valueOf(hasBait)))) {
            level.setBlock(pos, newState, 11);
        } else {
            level.sendBlockUpdated(pos, state, newState, 11);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof FishTrapBlockEntity) {
            FishTrapBlockEntity fishTrap = (FishTrapBlockEntity)blockEntity;
            for (int i = 0; i < fishTrap.getContainerSize(); ++i) {
                ItemStack stack = fishTrap.getItem(i);
                if (stack.isEmpty()) continue;
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
            }
            level.removeBlockEntity(pos);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }
}

