/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class FishNetFenceBlock
extends CrossCollisionBlock {
    private static final VoxelShape POST_SHAPE = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape NORTH_SHAPE = Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)7.0);
    private static final VoxelShape SOUTH_SHAPE = Block.box((double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)0.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0);
    private static final VoxelShape EAST_SHAPE = Block.box((double)9.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final MapCodec<FishNetFenceBlock> CODEC = FishNetFenceBlock.simpleCodec(FishNetFenceBlock::new);

    public FishNetFenceBlock(BlockBehaviour.Properties properties) {
        super(2.0f, 2.0f, 16.0f, 16.0f, 16.0f, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends CrossCollisionBlock> codec() {
        return CODEC;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape shape = POST_SHAPE;
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)NORTH_SHAPE);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SOUTH_SHAPE);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)WEST_SHAPE);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)EAST_SHAPE);
        }
        return shape;
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    private boolean connectsTo(BlockState state) {
        return state.getBlock() instanceof FishNetFenceBlock || state.isSolidRender(null, null);
    }

    private boolean hasBellAbove(Level level, BlockPos pos) {
        for (int i = 1; i <= 32; ++i) {
            BlockState stateAbove = level.getBlockState(pos.above(i));
            if (stateAbove.getBlock() instanceof BellBlock) {
                return true;
            }
            if (stateAbove.isAir()) break;
        }
        return false;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (!level.isClientSide && this.hasBellAbove(level, blockPos)) {
            level.playSound(null, blockPos, SoundEvents.BELL_RESONATE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        FluidState fluidState = world.getFluidState(pos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo(world.getBlockState(pos.north()))))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo(world.getBlockState(pos.east()))))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo(world.getBlockState(pos.south()))))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo(world.getBlockState(pos.west()))))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (direction.getAxis().isHorizontal()) {
            return (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.connectsTo(newState)));
        }
        return super.updateShape(state, direction, newState, world, pos, neighborPos);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.is(state.getBlock())) {
            world.playSound(null, pos, state.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, WATERLOGGED});
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getShape(state, world, pos, context);
    }
}

