/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.satisfy.lilis_lucky_lures.client.model.entity.FloatingBooksModel;
import net.satisfy.lilis_lucky_lures.core.entity.FloatingBooksEntity;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresIdentifier;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class FloatingBooksRenderer
extends EntityRenderer<FloatingBooksEntity> {
    private static final ResourceLocation TEXTURE = LilisLuckyLuresIdentifier.identifier("textures/entity/floating_books.png");
    private final FloatingBooksModel<FloatingBooksEntity> model;

    public FloatingBooksRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new FloatingBooksModel(context.bakeLayer(FloatingBooksModel.LAYER_LOCATION));
    }

    @NotNull
    public ResourceLocation getTextureLocation(FloatingBooksEntity entity) {
        return TEXTURE;
    }

    public void render(FloatingBooksEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        Quaternionf rotation = new Quaternionf().rotateY((float)Math.toRadians(entity.getRandomRotation()));
        poseStack.last().pose().rotate((Quaternionfc)rotation);
        float ageInTicks = (float)entity.tickCount + partialTicks;
        this.model.setupAnim(entity, 0.0f, 0.0f, ageInTicks, entityYaw, 0.0f);
        int overlay = entity.getHurtTime() > 0 ? 3 : OverlayTexture.NO_OVERLAY;
        this.model.renderToBuffer(poseStack, buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE)), packedLight, overlay);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }
}

