/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.lilis_lucky_lures.core.block.FishTrapBlock;
import net.satisfy.lilis_lucky_lures.core.block.entity.FishTrapBlockEntity;
import org.joml.Quaternionf;

public class FishTrapBlockEntityRenderer
implements BlockEntityRenderer<FishTrapBlockEntity> {
    private long lastRenderTime = 0L;
    private float rotationAngle = 0.0f;
    private float movementTime = 0.0f;

    private void updateMovement(FishTrapBlockEntity blockEntity) {
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.lastRenderTime == 0L) {
            this.lastRenderTime = currentTime;
        }
        float deltaTime = (float)(currentTime - this.lastRenderTime) / 1000.0f;
        this.lastRenderTime = currentTime;
        this.rotationAngle += deltaTime * 40.0f;
        this.rotationAngle %= 360.0f;
        this.movementTime += deltaTime * 1.5f;
    }

    public void render(FishTrapBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        ItemStack itemToRender;
        if (blockEntity.getLevel() == null) {
            return;
        }
        BlockState state = blockEntity.getLevel().getBlockState(blockEntity.getBlockPos());
        if (!(state.getBlock() instanceof FishTrapBlock)) {
            return;
        }
        boolean isFull = (Boolean)state.getValue((Property)FishTrapBlock.FULL);
        boolean hasBait = (Boolean)state.getValue((Property)FishTrapBlock.HAS_BAIT);
        boolean isHanging = (Boolean)state.getValue((Property)FishTrapBlock.HANGING);
        ItemStack itemStack = isFull ? blockEntity.getItem(1) : (itemToRender = hasBait ? blockEntity.getItem(0) : ItemStack.EMPTY);
        if (!itemToRender.isEmpty()) {
            this.updateMovement(blockEntity);
            poseStack.pushPose();
            float angle = (float)Math.toRadians(this.rotationAngle);
            float radius = 0.12f;
            float baseYOffset = isHanging ? 0.125f : 0.0f;
            float xOffset = (float)Math.sin(this.movementTime) * 0.12f;
            float zOffset = (float)Math.cos(this.movementTime) * 0.12f;
            float yWave = (float)Math.sin(this.movementTime * 1.5f) * 0.05f;
            float tiltAngleX = (float)Math.sin(this.movementTime * 1.2f) * 5.0f;
            float tiltAngleZ = (float)Math.cos(this.movementTime * 1.4f) * 5.0f;
            poseStack.translate(0.5 + (double)xOffset, 0.1 + (double)baseYOffset + (double)yWave, 0.5 + (double)zOffset);
            poseStack.mulPose(new Quaternionf().rotationY(angle));
            poseStack.mulPose(new Quaternionf().rotationX((float)Math.toRadians(tiltAngleX)));
            poseStack.mulPose(new Quaternionf().rotationZ((float)Math.toRadians(tiltAngleZ)));
            float scale = 0.85f;
            poseStack.scale(scale, scale, scale);
            Minecraft.getInstance().getItemRenderer().renderStatic(itemToRender, ItemDisplayContext.GROUND, 0xF00000, combinedOverlay, poseStack, bufferSource, blockEntity.getLevel(), 0);
            poseStack.popPose();
        }
    }
}

