/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.satisfy.lilis_lucky_lures.core.entity.FloatingDebrisEntity;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresIdentifier;

public class FloatingBooksModel<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(LilisLuckyLuresIdentifier.identifier("floating_books"), "main");
    private final ModelPart book_1;
    private final ModelPart book_2;
    private final ModelPart lectern;
    private final float baseYBook_1;
    private final float baseYBook_2;
    private final float baseYLectern;

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition book_1 = partdefinition.addOrReplaceChild("book_1", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)30.0f, (float)0.0f));
        PartDefinition book_2_r1 = book_1.addOrReplaceChild("book_2_r1", CubeListBuilder.create().texOffs(0, 20).addBox(-8.0f, -3.0f, -1.0f, 9.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)1.0f, (float)-19.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition book_2 = partdefinition.addOrReplaceChild("book_2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)30.0f, (float)15.0f, (float)0.0f, (float)0.6109f, (float)0.0f));
        PartDefinition book_2_r2 = book_2.addOrReplaceChild("book_2_r2", CubeListBuilder.create().texOffs(0, 33).addBox(-8.0f, -3.0f, -1.0f, 9.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)14.0f, (float)1.0f, (float)-3.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition lectern = partdefinition.addOrReplaceChild("lectern", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)30.0f, (float)0.0f));
        PartDefinition lectern_r1 = lectern.addOrReplaceChild("lectern_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-15.0f, -4.0f, -1.0f, 16.0f, 4.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0f, (float)1.0f, (float)-1.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public FloatingBooksModel(ModelPart root) {
        this.book_1 = root.getChild("book_1");
        this.book_2 = root.getChild("book_2");
        this.lectern = root.getChild("lectern");
        this.baseYBook_1 = this.book_1.y;
        this.baseYBook_2 = this.book_2.y;
        this.baseYLectern = this.lectern.y;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof FloatingDebrisEntity) {
            FloatingDebrisEntity debrisEntity = (FloatingDebrisEntity)((Object)entity);
            float timeFactor = ageInTicks * 0.1f;
            float book_1Oscillation = (float)Math.sin(timeFactor + 0.5f) * 0.25f;
            float book_2Oscillation = (float)Math.sin(timeFactor + 0.3f) * 0.35f;
            float lecternOscillation = (float)Math.sin(timeFactor + 0.7f) * 0.3f;
            float book_1Rotation = (float)Math.cos(timeFactor * 0.8f) * 0.05f;
            float book_2Rotation = (float)Math.sin(timeFactor * 0.7f) * 0.07f;
            float lecternRotation = (float)Math.cos(timeFactor * 0.6f) * 0.06f;
            float sideDriftX = (float)Math.sin(timeFactor * 0.4f) * 0.2f;
            float sideDriftZ = (float)Math.cos(timeFactor * 0.4f) * 0.2f;
            this.book_1.setPos(sideDriftX, this.baseYBook_1 + book_1Oscillation, sideDriftZ);
            this.book_2.setPos(-sideDriftX, this.baseYBook_2 + book_2Oscillation, -sideDriftZ);
            this.lectern.setPos(sideDriftZ, this.baseYLectern + lecternOscillation, -sideDriftX);
            this.book_1.xRot = book_1Rotation;
            this.book_2.zRot = book_2Rotation;
            this.lectern.xRot = lecternRotation;
            if (debrisEntity.getHurtTime() > 0) {
                int hurtTime = debrisEntity.getHurtTime();
                int maxHurtTime = 10;
                float hurtProgress = 1.0f - (float)hurtTime / (float)maxHurtTime;
                float offset = (float)Math.sin((double)(hurtProgress * 2.0f) * Math.PI) * 0.5f;
                float explosionOffsetX = (float)Math.sin((double)hurtProgress * Math.PI * 2.0) * 0.5f;
                float explosionOffsetZ = (float)Math.cos((double)hurtProgress * Math.PI * 2.0) * 0.5f;
                this.book_1.setPos(explosionOffsetX, this.baseYBook_1 + offset, explosionOffsetZ);
                this.book_2.setPos(-explosionOffsetX, this.baseYBook_2 + offset, -explosionOffsetZ);
                this.lectern.setPos(explosionOffsetZ, this.baseYLectern + offset, explosionOffsetX);
            }
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int red) {
        this.book_1.render(poseStack, vertexConsumer, packedLight, packedOverlay, red);
        this.book_2.render(poseStack, vertexConsumer, packedLight, packedOverlay, red);
        this.lectern.render(poseStack, vertexConsumer, packedLight, packedOverlay, red);
    }
}

