/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.util;

import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.RandomTickPart;
import codechicken.multipart.block.TileMultipart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

class WorldTickScheduler
extends SavedData {
    private final ServerLevel world;
    private final Map<ChunkPos, ChunkScheduler> chunks = new HashMap<ChunkPos, ChunkScheduler>();
    private final List<ChunkScheduler> ticking = new LinkedList<ChunkScheduler>();
    private final List<ChunkScheduler> tickingPending = new LinkedList<ChunkScheduler>();
    private boolean isTicking;

    public static WorldTickScheduler getInstance(ServerLevel level) {
        return (WorldTickScheduler)level.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> new WorldTickScheduler(level), (t, r) -> new WorldTickScheduler(level, (CompoundTag)t)), "cb_multipart_scheduled_ticks");
    }

    public static ChunkScheduler getInstance(LevelChunk chunk) {
        return WorldTickScheduler.getInstance((ServerLevel)chunk.getLevel()).getChunkScheduler(chunk);
    }

    WorldTickScheduler(ServerLevel world) {
        this.world = world;
    }

    WorldTickScheduler(ServerLevel world, CompoundTag tag) {
        this.world = world;
        this.load(tag);
    }

    private void load(CompoundTag tag) {
        ListTag chunksList = tag.getList("Chunks", 10);
        for (int i = 0; i < chunksList.size(); ++i) {
            CompoundTag chunkTag = chunksList.getCompound(i);
            ChunkPos pos = new ChunkPos(chunkTag.getInt("ChunkX"), chunkTag.getInt("ChunkZ"));
            ChunkScheduler chunkScheduler = new ChunkScheduler(this, pos);
            chunkScheduler.load(chunkTag);
            this.chunks.put(pos, chunkScheduler);
        }
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        ListTag chunksList = new ListTag();
        for (ChunkScheduler chunk : this.chunks.values()) {
            CompoundTag chunkTag = chunk.save(new CompoundTag());
            if (chunkTag == null) continue;
            chunkTag.putInt("ChunkX", chunk.pos.x);
            chunkTag.putInt("ChunkZ", chunk.pos.z);
            chunksList.add((Object)chunkTag);
        }
        tag.put("Chunks", (Tag)chunksList);
        return tag;
    }

    public boolean isDirty() {
        return true;
    }

    public ChunkScheduler getChunkScheduler(LevelChunk chunk) {
        return this.chunks.computeIfAbsent(chunk.getPos(), pos -> {
            ChunkScheduler scheduler = new ChunkScheduler(this, (ChunkPos)pos);
            if (chunk.loaded) {
                scheduler.onChunkLoad(chunk);
            }
            return scheduler;
        });
    }

    public void onChunkUnload(LevelChunk chunk) {
        ChunkPos pos = chunk.getPos();
        this.ticking.removeIf(e -> {
            if (!e.pos.equals((Object)pos)) {
                return false;
            }
            e.onChunkUnload();
            return true;
        });
    }

    public void onChunkLoad(LevelChunk chunk) {
        ChunkPos pos = chunk.getPos();
        ChunkScheduler scheduler = this.chunks.get(pos);
        if (scheduler != null) {
            scheduler.onChunkLoad(chunk);
        }
    }

    public void tick() {
        this.isTicking = true;
        this.ticking.removeIf(ChunkScheduler::tick);
        this.isTicking = false;
        this.ticking.addAll(this.tickingPending);
        this.tickingPending.clear();
    }

    public void startTicking(ChunkScheduler chunkScheduler) {
        if (this.isTicking) {
            this.tickingPending.add(chunkScheduler);
        } else {
            this.ticking.add(chunkScheduler);
        }
    }

    static class ChunkScheduler {
        private final WorldTickScheduler worldScheduler;
        private final ChunkPos pos;
        @Nullable
        private LevelChunk chunk;
        private final List<SavedTickEntry> savedTicks = new ArrayList<SavedTickEntry>();
        private final List<PartTickEntry> scheduledTicks = new LinkedList<PartTickEntry>();
        private final List<PartTickEntry> randomTicks = new LinkedList<PartTickEntry>();
        private boolean ticking = false;
        private final List<PartTickEntry> pendingScheduled = new LinkedList<PartTickEntry>();
        private final List<PartTickEntry> pendingRandom = new LinkedList<PartTickEntry>();

        ChunkScheduler(WorldTickScheduler worldScheduler, ChunkPos pos) {
            this.worldScheduler = worldScheduler;
            this.pos = pos;
        }

        private void load(CompoundTag tag) {
            FastStream.of((Iterable)tag.getList("ticks", 10)).map(e -> (CompoundTag)e).map(SavedTickEntry::new).forEach(this.savedTicks::add);
        }

        @Nullable
        private CompoundTag save(CompoundTag tag) {
            if (this.scheduledTicks.isEmpty() && this.savedTicks.isEmpty()) {
                return null;
            }
            ListTag tickList = new ListTag();
            FastStream.of(this.scheduledTicks).map(PartTickEntry::write).filter(Objects::nonNull).forEach(arg_0 -> tickList.add(arg_0));
            this.savedTicks.forEach(e -> tickList.add((Object)e.write()));
            tag.put("ticks", (Tag)tickList);
            return tag;
        }

        public void addScheduledTick(MultiPart part, int time) {
            PartTickEntry entry = new PartTickEntry(part, this.worldScheduler.world.getGameTime() + (long)time, false);
            if (this.ticking) {
                this.pendingScheduled.add(entry);
            } else {
                this.scheduledTicks.add(entry);
                this.onAdd();
            }
        }

        public void loadRandomTick(MultiPart part) {
            this.addRandomTick(part, this.worldScheduler.world.getGameTime() + (long)this.nextRandomTick());
        }

        public void addRandomTick(MultiPart part, long time) {
            PartTickEntry entry = new PartTickEntry(part, time, true);
            if (this.ticking) {
                this.pendingRandom.add(entry);
            } else {
                this.randomTicks.add(entry);
                this.onAdd();
            }
        }

        private void onAdd() {
            if (this.scheduledTicks.isEmpty() && this.randomTicks.isEmpty()) {
                return;
            }
            this.worldScheduler.startTicking(this);
        }

        private void onChunkUnload() {
            this.chunk = null;
        }

        private void onChunkLoad(LevelChunk chunk) {
            if (this.chunk != null) {
                throw new RuntimeException("Chunk already loaded?");
            }
            this.chunk = chunk;
            for (SavedTickEntry savedTick : this.savedTicks) {
                BlockEntity tileEntity = (BlockEntity)chunk.getBlockEntities().get(savedTick.pos);
                if (!(tileEntity instanceof TileMultipart)) continue;
                TileMultipart tile = (TileMultipart)tileEntity;
                this.scheduledTicks.add(new PartTickEntry(tile.getPartList().get(savedTick.idx), savedTick.time, false));
            }
            this.savedTicks.clear();
            this.onAdd();
        }

        private boolean tick() {
            if (this.chunk == null) {
                return true;
            }
            this.ticking = true;
            this.doTicks(this.scheduledTicks);
            this.doTicks(this.randomTicks);
            this.ticking = false;
            this.scheduledTicks.addAll(this.pendingScheduled);
            this.randomTicks.addAll(this.pendingRandom);
            this.pendingScheduled.clear();
            this.pendingRandom.clear();
            return this.scheduledTicks.isEmpty() && this.randomTicks.isEmpty() || !this.chunk.loaded;
        }

        private void doTicks(List<PartTickEntry> list) {
            long time = this.worldScheduler.world.getGameTime();
            list.removeIf(entry -> {
                if (entry.time > time) {
                    return false;
                }
                if (entry.part.hasTile()) {
                    if (entry.random) {
                        if (entry.part instanceof RandomTickPart) {
                            ((RandomTickPart)entry.part).randomTick();
                        }
                        this.addRandomTick(entry.part, time + (long)this.nextRandomTick());
                    } else {
                        entry.part.scheduledTick();
                    }
                }
                return true;
            });
        }

        private int nextRandomTick() {
            return this.worldScheduler.world.getRandom().nextInt(800) + 800;
        }
    }

    private static class SavedTickEntry {
        public final BlockPos pos;
        public final int idx;
        public final long time;

        public SavedTickEntry(CompoundTag tag) {
            this.pos = SavedTickEntry.readBlockPos(tag.getCompound("pos"));
            this.idx = tag.getInt("idx");
            this.time = tag.getLong("time");
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.put("pos", (Tag)SavedTickEntry.writeBlockPos(this.pos));
            tag.putInt("idx", this.idx);
            tag.putLong("time", this.time);
            return tag;
        }

        private static BlockPos readBlockPos(CompoundTag tag) {
            return new BlockPos(tag.getInt("X"), tag.getInt("Y"), tag.getInt("Z"));
        }

        private static CompoundTag writeBlockPos(BlockPos tag) {
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.putInt("X", tag.getX());
            compoundtag.putInt("Y", tag.getY());
            compoundtag.putInt("Z", tag.getZ());
            return compoundtag;
        }
    }

    private static class PartTickEntry {
        public final MultiPart part;
        public final long time;
        public final boolean random;

        private PartTickEntry(MultiPart part, long time, boolean random) {
            this.part = part;
            this.time = time;
            this.random = random;
        }

        @Nullable
        public CompoundTag write() {
            if (!this.part.hasTile()) {
                return null;
            }
            CompoundTag tag = new CompoundTag();
            tag.put("pos", NbtUtils.writeBlockPos((BlockPos)this.part.pos()));
            tag.putInt("idx", this.part.tile().getPartList().indexOf(this.part));
            tag.putLong("time", this.time);
            return tag;
        }
    }
}

