/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.util;

import codechicken.asm.ASMHelper;
import codechicken.asm.ObfMapping;
import codechicken.mixin.SidedFactory;
import codechicken.mixin.api.MixinBackend;
import codechicken.mixin.api.MixinCompiler;
import codechicken.mixin.api.MixinDebugger;
import codechicken.mixin.api.MixinFactory;
import codechicken.mixin.api.MixinLanguageSupport;
import codechicken.mixin.util.JavaTraitGenerator;
import codechicken.mixin.util.SimpleDebugger;
import codechicken.mixin.util.Utils;
import codechicken.multipart.api.RegisterMultipartTraitsEvent;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.BlockMultipart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.init.CBMultipartModContent;
import codechicken.multipart.trait.TileMultipartClient;
import codechicken.multipart.util.ForgeMixinBackend;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.CrashLock;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class MultipartGenerator
extends SidedFactory<TileMultipart, Factory, MultiPart> {
    private static final Logger logger = LogManager.getLogger();
    private static final CrashLock LOCK = new CrashLock("Already initialized.");
    @Nullable
    private static final SimpleDebugger.DumpType DEBUG_TYPE = MultipartGenerator.parseType(System.getProperty("codechicken.multipart.debug", null));
    public static final MultipartGenerator INSTANCE = new MultipartGenerator();
    public static final MixinCompiler MIXIN_COMPILER = INSTANCE.getMixinCompiler();
    private final Map<String, MixinFactory.TraitKey> passthroughTraits = new HashMap<String, MixinFactory.TraitKey>();
    private final MixinFactory.TraitKey clientTrait = this.registerTrait(TileMultipartClient.class);

    private MultipartGenerator() {
        super(MixinCompiler.create((MixinBackend)new ForgeMixinBackend(), (MixinDebugger)MultipartGenerator.makeDebugger()), TileMultipart.class, Factory.class, "cmp");
        Objects.requireNonNull((MixinLanguageSupport.JavaMixinLanguageSupport)this.mixinCompiler.getLanguageSupport("java")).setTraitGeneratorFactory(MultipartJavaTraitGenerator::new);
    }

    public void registerPassThroughInterface(Class<?> iFace) {
        this.registerPassThroughInterface(iFace, true, true);
    }

    public void registerPassThroughInterface(Class<?> iFace, boolean client, boolean server) {
        MixinFactory.TraitKey key = this.registerPassthroughTrait(iFace);
        Class trait = this.mixinCompiler.getDefinedClass(key.tName());
        this.registerTrait(iFace, client ? trait : null, server ? trait : null);
    }

    public void load(IEventBus modBus) {
        LOCK.lock();
        modBus.addListener(this::onModLoadingComplete);
    }

    private void onModLoadingComplete(FMLLoadCompleteEvent event) {
        ModLoader.postEvent((Event)new RegisterMultipartTraitsEvent(this));
    }

    public ImmutableSet<MixinFactory.TraitKey> getTraits(MultiPart part, boolean client) {
        return this.getTraits(Collections.singleton(part), client);
    }

    public ImmutableSet<MixinFactory.TraitKey> getTraits(Collection<MultiPart> parts, boolean client) {
        return FastStream.concat((Iterable[])new Iterable[]{client ? FastStream.of((Object)this.clientTrait) : FastStream.of(), FastStream.of(parts).flatMap(e -> this.getTraitsForObject(e, client))}).toImmutableSet();
    }

    public TileMultipart generateCompositeTile(@Nullable BlockEntity tile, BlockPos pos, Collection<MultiPart> parts, boolean client) {
        ImmutableSet<MixinFactory.TraitKey> traits = this.getTraits(parts, client);
        if (tile instanceof TileMultipart && traits.equals((Object)this.getTraitsForClass(tile.getClass()))) {
            return (TileMultipart)tile;
        }
        return ((Factory)this.construct(traits)).newInstance(pos, ((BlockMultipart)((Object)CBMultipartModContent.MULTIPART_BLOCK.get())).defaultBlockState());
    }

    public MixinFactory.TraitKey registerPassthroughTrait(Class<?> iClass) {
        String iName = Utils.asmName(iClass);
        MixinFactory.TraitKey key = this.passthroughTraits.get(iName);
        if (key != null) {
            return key;
        }
        String simpleName = iName.substring(iName.lastIndexOf(47) + 1);
        if (simpleName.startsWith("I") && simpleName.length() > 1 && Character.isUpperCase(simpleName.charAt(1))) {
            simpleName = simpleName.substring(1);
        }
        String tName = "T" + simpleName + "$$PassThrough";
        String vName = "impl";
        String iDesc = "L" + iName + ";";
        ClassNode mpCNode = Objects.requireNonNull(this.mixinCompiler.getClassNode(Utils.asmName(TileMultipart.class)), "Did not get class for TileMultipart?");
        ClassNode iNode = this.mixinCompiler.getClassNode(iName);
        if (iNode == null) {
            SneakyUtils.throwUnchecked((Throwable)new ClassNotFoundException("Unable to generate PassThrough trait for interface: " + iName + ", class not found."));
            return null;
        }
        if ((iNode.access & 0x200) == 0) {
            throw new IllegalArgumentException("Class: " + iName + ", is not an interface.");
        }
        ClassNode cNode = new ClassNode();
        cNode.visit(52, 32, tName, null, "codechicken/multipart/block/TileMultipart", new String[]{iName});
        FieldVisitor fv = cNode.visitField(2, vName, iDesc, null, null);
        fv.visitEnd();
        MethodNode superCtor = (MethodNode)FastStream.of((Iterable)mpCNode.methods).filter(e -> e.name.equals("<init>")).only();
        MethodVisitor mv = cNode.visitMethod(1, "<init>", superCtor.desc, null, null);
        mv.visitCode();
        int idx = 0;
        mv.visitVarInsn(25, idx++);
        for (Type arg : Type.getArgumentTypes((String)superCtor.desc)) {
            mv.visitVarInsn(arg.getOpcode(21), idx);
            idx += arg.getSize();
        }
        mv.visitMethodInsn(183, "codechicken/multipart/block/TileMultipart", "<init>", superCtor.desc, false);
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        MethodVisitor mv2 = cNode.visitMethod(1, "bindPart", "(Lcodechicken/multipart/api/part/MultiPart;)V", null, null);
        mv2.visitCode();
        mv2.visitVarInsn(25, 0);
        mv2.visitVarInsn(25, 1);
        mv2.visitMethodInsn(183, "codechicken/multipart/block/TileMultipart", "bindPart", "(Lcodechicken/multipart/api/part/MultiPart;)V", false);
        mv2.visitVarInsn(25, 1);
        mv2.visitTypeInsn(193, iName);
        Label l2 = new Label();
        mv2.visitJumpInsn(153, l2);
        mv2.visitVarInsn(25, 0);
        mv2.visitVarInsn(25, 1);
        mv2.visitTypeInsn(192, iName);
        mv2.visitFieldInsn(181, tName, vName, iDesc);
        mv2.visitLabel(l2);
        mv2.visitInsn(177);
        mv2.visitMaxs(-1, -1);
        mv2.visitEnd();
        mv2 = cNode.visitMethod(1, "partRemoved", "(Lcodechicken/multipart/api/part/MultiPart;I)V", null, null);
        mv2.visitCode();
        mv2.visitVarInsn(25, 0);
        mv2.visitVarInsn(25, 1);
        mv2.visitVarInsn(21, 2);
        mv2.visitMethodInsn(183, "codechicken/multipart/block/TileMultipart", "partRemoved", "(Lcodechicken/multipart/api/part/MultiPart;I)V", false);
        mv2.visitVarInsn(25, 1);
        mv2.visitVarInsn(25, 0);
        mv2.visitFieldInsn(180, tName, vName, iDesc);
        l2 = new Label();
        mv2.visitJumpInsn(166, l2);
        mv2.visitVarInsn(25, 0);
        mv2.visitInsn(1);
        mv2.visitFieldInsn(181, tName, vName, iDesc);
        mv2.visitLabel(l2);
        mv2.visitInsn(177);
        mv2.visitMaxs(-1, -1);
        mv2.visitEnd();
        mv2 = cNode.visitMethod(1, "canAddPart", "(Lcodechicken/multipart/api/part/MultiPart;)Z", null, null);
        mv2.visitCode();
        mv2.visitVarInsn(25, 0);
        mv2.visitFieldInsn(180, tName, vName, iDesc);
        Label l1 = new Label();
        mv2.visitJumpInsn(198, l1);
        mv2.visitVarInsn(25, 1);
        mv2.visitTypeInsn(193, iName);
        mv2.visitJumpInsn(153, l1);
        mv2.visitInsn(3);
        mv2.visitInsn(172);
        mv2.visitLabel(l1);
        mv2.visitVarInsn(25, 0);
        mv2.visitVarInsn(25, 1);
        mv2.visitMethodInsn(183, "codechicken/multipart/block/TileMultipart", "canAddPart", "(Lcodechicken/multipart/api/part/MultiPart;)Z", false);
        mv2.visitInsn(172);
        mv2.visitMaxs(-1, -1);
        mv2.visitEnd();
        this.methods(iNode).forEach(m -> {
            MethodVisitor mv = cNode.visitMethod(1, m.name, m.desc, m.signature, m.exceptions.toArray(new String[0]));
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, tName, vName, iDesc);
            Utils.finishBridgeCall((MethodVisitor)mv, (String)m.desc, (int)185, (String)iName, (String)m.name, (String)m.desc, (boolean)true);
        });
        cNode.visitEnd();
        key = this.registerTrait(cNode);
        this.passthroughTraits.put(iName, key);
        return key;
    }

    private Collection<MethodNode> methods(ClassNode cNode) {
        return this.getAllMethods(new HashSet<String>(), cNode).collect(Collectors.toMap(Pair::getLeft, Pair::getRight)).values();
    }

    private Stream<Pair<String, MethodNode>> getAllMethods(Set<String> visited, ClassNode cNode) {
        Stream<Pair<String, MethodNode>> methods = cNode.methods.stream().map(m -> Pair.of((Object)(m.name + m.desc), (Object)m));
        if (visited.add(cNode.name)) {
            if (!cNode.interfaces.isEmpty()) {
                Stream others = cNode.interfaces.stream().filter(visited::add).map(arg_0 -> ((MixinCompiler)this.mixinCompiler).getClassNode(arg_0)).flatMap(e -> this.getAllMethods(visited, (ClassNode)e));
                return Streams.concat((Stream[])new Stream[]{methods, others});
            }
            return methods;
        }
        return Stream.empty();
    }

    private static SimpleDebugger.DumpType parseType(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return SimpleDebugger.DumpType.valueOf((String)value);
    }

    private static MixinDebugger makeDebugger() {
        if (DEBUG_TYPE == null) {
            return new MixinDebugger.NullDebugger();
        }
        return new SimpleDebugger(Paths.get("./asm/multipart", new String[0]), DEBUG_TYPE);
    }

    public static interface Factory {
        public TileMultipart newInstance(BlockPos var1, BlockState var2);
    }

    private static class MultipartJavaTraitGenerator
    extends JavaTraitGenerator {
        public MultipartJavaTraitGenerator(MixinCompiler mixinCompiler, ClassNode cNode) {
            super(mixinCompiler, cNode);
        }

        protected void preCheckNode() {
            if ((this.cNode.access & 0x200) != 0) {
                throw new IllegalArgumentException("Cannot register java interface '" + this.cNode.name + "' as a mixin trait. Try as a PassthroughInterface.");
            }
        }

        protected void beforeTransform() {
            ObfMapping m_copyFrom = new ObfMapping(this.cNode.name, "copyFrom", "(Lcodechicken/multipart/block/TileMultipart;)V");
            if (!this.instanceFields.isEmpty() && ASMHelper.findMethod((ObfMapping)m_copyFrom, (ClassNode)this.cNode) == null) {
                MethodVisitor mv = m_copyFrom.visitMethod((ClassVisitor)this.cNode, 1, null);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(183, "codechicken/multipart/block/TileMultipart", m_copyFrom.s_name, m_copyFrom.s_desc, false);
                mv.visitVarInsn(25, 1);
                mv.visitTypeInsn(193, this.cNode.name);
                Label end = new Label();
                mv.visitJumpInsn(153, end);
                this.instanceFields.forEach(f -> {
                    mv.visitVarInsn(25, 0);
                    mv.visitVarInsn(25, 1);
                    mv.visitFieldInsn(180, this.cNode.name, f.name, f.desc);
                    mv.visitFieldInsn(181, this.cNode.name, f.name, f.desc);
                });
                mv.visitLabel(end);
                mv.visitInsn(177);
                mv.visitMaxs(-1, -1);
                mv.visitEnd();
            }
        }
    }
}

