/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.client;

import codechicken.lib.texture.TextureUtils;
import codechicken.multipart.api.MultipartClientRegistry;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.render.PartRenderer;
import codechicken.multipart.client.MultipartModelData;
import codechicken.multipart.util.PartRayTraceResult;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.util.ConcatenatedListView;
import org.jetbrains.annotations.Nullable;

public class MultipartTileBakedModel
implements IDynamicBakedModel {
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData data, @Nullable RenderType renderType) {
        HitResult hitResult;
        MultipartModelData multipartData = (MultipartModelData)data.get(MultipartModelData.DATA);
        if (multipartData == null) {
            return List.of();
        }
        if (renderType == null && (hitResult = Minecraft.getInstance().hitResult) instanceof PartRayTraceResult) {
            PartRayTraceResult hit = (PartRayTraceResult)hitResult;
            return MultipartTileBakedModel.getPartQuads(hit.part, side, rand, multipartData.partsAndData().getOrDefault(hit.part, ModelData.EMPTY), null);
        }
        List<MultiPart> parts = multipartData.tile().getPartList();
        ArrayList<List<BakedQuad>> quads = new ArrayList<List<BakedQuad>>(parts.size());
        for (MultiPart part : parts) {
            List<BakedQuad> partQuads = MultipartTileBakedModel.getPartQuads(part, side, rand, multipartData.partsAndData().getOrDefault(part, ModelData.EMPTY), renderType);
            if (partQuads.isEmpty()) continue;
            quads.add(partQuads);
        }
        return ConcatenatedListView.of(quads);
    }

    private static List<BakedQuad> getPartQuads(MultiPart part, @Nullable Direction side, RandomSource rand, ModelData data, @Nullable RenderType renderType) {
        PartRenderer<MultiPart> renderer = MultipartClientRegistry.getRenderer(part.getType());
        if (renderer != null) {
            return renderer.getQuads(part, side, rand, data, renderType);
        }
        return List.of();
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return true;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return TextureUtils.getMissingSprite();
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }
}

