/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.client;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.multipart.api.MultipartClientRegistry;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.render.PartRenderer;
import codechicken.multipart.block.BlockMultipart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.init.CBMultipartModContent;
import codechicken.multipart.util.PartRayTraceResult;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
public class MultipartBlockRenderer
implements ICCBlockRenderer {
    public boolean canHandleBlock(BlockAndTintGetter world, BlockPos pos, BlockState blockState, @Nullable RenderType renderType) {
        return blockState.getBlock() == CBMultipartModContent.MULTIPART_BLOCK.get();
    }

    public void renderBlock(BlockState state, BlockPos pos, BlockAndTintGetter world, PoseStack mStack, VertexConsumer builder, RandomSource random, ModelData data, @Nullable RenderType renderType) {
        TileMultipart tile = BlockMultipart.getTile((BlockGetter)world, pos);
        if (tile == null) {
            return;
        }
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.bind((VertexConsumer)new TransformingVertexConsumer(builder, mStack), DefaultVertexFormat.BLOCK);
        ccrs.lightMatrix.locate(world, pos);
        this.renderStatic(tile, renderType, ccrs);
    }

    public void renderBreaking(BlockState state, BlockPos pos, BlockAndTintGetter world, PoseStack mStack, VertexConsumer builder, ModelData data) {
        TileMultipart tile = BlockMultipart.getTile((BlockGetter)world, pos);
        if (tile == null) {
            return;
        }
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        mStack.pushPose();
        ccrs.bind((VertexConsumer)new TransformingVertexConsumer(builder, mStack), DefaultVertexFormat.BLOCK);
        ccrs.overlay = OverlayTexture.NO_OVERLAY;
        ccrs.brightness = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockState)state, (BlockPos)pos);
        ccrs.lightMatrix.locate(world, pos);
        this.renderBreaking(tile, ccrs);
        mStack.popPose();
    }

    private void renderStatic(TileMultipart tile, @Nullable RenderType type, CCRenderState ccrs) {
        for (MultiPart part : tile.getPartList()) {
            PartRenderer<MultiPart> renderer = MultipartClientRegistry.getRenderer(part.getType());
            if (renderer == null) continue;
            renderer.renderStatic((MultiPart)SneakyUtils.unsafeCast((Object)part), type, ccrs);
        }
    }

    private void renderBreaking(TileMultipart tile, CCRenderState ccrs) {
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (hitResult instanceof PartRayTraceResult) {
            PartRayTraceResult hit = (PartRayTraceResult)hitResult;
            PartRenderer<MultiPart> renderer = MultipartClientRegistry.getRenderer(hit.part.getType());
            if (renderer != null) {
                renderer.renderBreaking((MultiPart)SneakyUtils.unsafeCast((Object)hit.part), ccrs);
            }
        }
    }
}

