/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.item;

import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.init.CBMicroblockModContent;
import codechicken.microblock.part.StandardMicroFactory;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public record MicroMaterialComponent(int factoryId, int size, MicroMaterial material) {
    public static final Codec<MicroMaterialComponent> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("factoryId").forGetter(MicroMaterialComponent::factoryId), (App)Codec.INT.fieldOf("size").forGetter(MicroMaterialComponent::size), (App)MicroMaterial.CODEC.fieldOf("material").forGetter(MicroMaterialComponent::material)).apply((Applicative)builder, MicroMaterialComponent::new));
    public static StreamCodec<RegistryFriendlyByteBuf, MicroMaterialComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, MicroMaterialComponent::factoryId, (StreamCodec)ByteBufCodecs.VAR_INT, MicroMaterialComponent::size, MicroMaterial.STREAM_CODEC, MicroMaterialComponent::material, MicroMaterialComponent::new);

    public MicroMaterialComponent {
        if (factoryId == -1) {
            throw new IllegalArgumentException("Illegal factory id.");
        }
    }

    @Contract(pure=true)
    @Nullable
    public StandardMicroFactory factory() {
        return (StandardMicroFactory)StandardMicroFactory.FACTORIES.get(this.factoryId);
    }

    @Nullable
    public static MicroMaterialComponent getComponent(ItemStack stack) {
        return (MicroMaterialComponent)stack.get(CBMicroblockModContent.MICRO_MATERIAL_COMPONENT);
    }
}

