/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.worldgen.processors.catacombs;

import com.mojang.serialization.MapCodec;
import com.naterbobber.darkerdepths.init.DDStructureProcessorTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class CatacombsBarrelProcessor
extends StructureProcessor {
    public static final MapCodec<CatacombsBarrelProcessor> CODEC = MapCodec.unit(CatacombsBarrelProcessor::new);

    @Nullable
    public StructureTemplate.StructureBlockInfo processBlock(LevelReader level, BlockPos templatePos, BlockPos worldPos, StructureTemplate.StructureBlockInfo blockInfo, StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings) {
        BlockState placeholderState = relativeBlockInfo.state();
        ResourceLocation lootTableId = null;
        if (placeholderState.is(Blocks.PISTON)) {
            lootTableId = ResourceLocation.fromNamespaceAndPath((String)"darkerdepths", (String)"chests/catacombs/standard");
        } else if (placeholderState.is(Blocks.STICKY_PISTON)) {
            lootTableId = ResourceLocation.fromNamespaceAndPath((String)"darkerdepths", (String)"chests/catacombs/treasure");
        }
        if (lootTableId != null) {
            Direction facing = (Direction)placeholderState.getValue((Property)BlockStateProperties.FACING);
            BlockState newBarrelState = (BlockState)Blocks.BARREL.defaultBlockState().setValue((Property)BarrelBlock.FACING, (Comparable)facing);
            CompoundTag nbt = new CompoundTag();
            nbt.putString("LootTable", lootTableId.toString());
            return new StructureTemplate.StructureBlockInfo(relativeBlockInfo.pos(), newBarrelState, nbt);
        }
        return relativeBlockInfo;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)DDStructureProcessorTypes.CATACOMBS_BARREL.get();
    }
}

