/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.worldgen.features;

import com.mojang.serialization.Codec;
import com.naterbobber.darkerdepths.worldgen.features.config.ReplaceListConfig;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class ReplaceListFeature
extends Feature<ReplaceListConfig> {
    public ReplaceListFeature(Codec<ReplaceListConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<ReplaceListConfig> context) {
        BlockPos blockpos1;
        ReplaceListConfig config = (ReplaceListConfig)context.config();
        WorldGenLevel worldgenlevel = context.level();
        RandomSource random = context.random();
        BlockPos blockpos = ReplaceListFeature.findTarget((LevelAccessor)worldgenlevel, context.origin().mutable().clamp(Direction.Axis.Y, worldgenlevel.getMinBuildHeight() + 1, worldgenlevel.getMaxBuildHeight() - 1), config);
        if (blockpos == null) {
            return false;
        }
        int i = config.radius().sample(random);
        int j = config.radius().sample(random);
        int k = config.radius().sample(random);
        int l = Math.max(i, Math.max(j, k));
        boolean flag = false;
        Iterator iterator = BlockPos.withinManhattan((BlockPos)blockpos, (int)i, (int)j, (int)k).iterator();
        while (iterator.hasNext() && (blockpos1 = (BlockPos)iterator.next()).distManhattan((Vec3i)blockpos) <= l) {
            BlockState blockstate = worldgenlevel.getBlockState(blockpos1);
            if (!config.targetList().contains(blockstate)) continue;
            this.setBlock((LevelWriter)worldgenlevel, blockpos1, config.replaceState());
            flag = true;
        }
        return flag;
    }

    @Nullable
    private static BlockPos findTarget(LevelAccessor p_66635_, BlockPos.MutableBlockPos mutable, ReplaceListConfig config) {
        while (mutable.getY() > p_66635_.getMinBuildHeight() + 1) {
            BlockState blockstate = p_66635_.getBlockState((BlockPos)mutable);
            if (config.targetList().contains(blockstate)) {
                return mutable;
            }
            mutable.move(Direction.DOWN);
        }
        return null;
    }
}

