/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.worldgen.features;

import com.mojang.serialization.Codec;
import com.naterbobber.darkerdepths.block.custom.GlowshroomBlock;
import com.naterbobber.darkerdepths.init.DDBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluids;

public class RandomSpreadFeature
extends Feature<NoneFeatureConfiguration> {
    public RandomSpreadFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        BlockPos blockPos = context.origin();
        RandomSource random = context.random();
        int tries = UniformInt.of((int)4, (int)10).sample(random);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < tries; ++i) {
            mutableBlockPos.setWithOffset((Vec3i)blockPos, random.nextInt(7) - random.nextInt(7), random.nextInt(3) - random.nextInt(3), random.nextInt(7) - random.nextInt(7));
            if (!world.getBlockState((BlockPos)mutableBlockPos).is(BlockTags.BASE_STONE_OVERWORLD) || !world.isStateAtPosition((BlockPos)mutableBlockPos, DripstoneUtils::isEmptyOrWater)) break;
            world.setBlock((BlockPos)mutableBlockPos, (BlockState)((BlockState)((GlowshroomBlock)((Object)DDBlocks.GLOWSHROOM.get())).defaultBlockState().setValue((Property)GlowshroomBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState((BlockPos)mutableBlockPos).getType() == Fluids.WATER))).setValue((Property)GlowshroomBlock.GLOWSHROOM_CLUSTERS, (Comparable)Integer.valueOf(1)), 2);
        }
        return false;
    }
}

