/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.worldgen.features;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.VegetationPatchFeature;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;

public class LavaVegetationPatchFeature
extends VegetationPatchFeature {
    public LavaVegetationPatchFeature(Codec<VegetationPatchConfiguration> codec) {
        super(codec);
    }

    protected Set<BlockPos> placeGroundPatch(WorldGenLevel world, VegetationPatchConfiguration config, RandomSource random, BlockPos pos, Predicate<BlockState> statePredicate, int xRadius, int zRadius) {
        Set landGroundPatch = super.placeGroundPatch(world, config, random, pos, statePredicate, xRadius, zRadius);
        HashSet<BlockPos> lavaGroundPatch = new HashSet<BlockPos>();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (BlockPos positions : landGroundPatch) {
            if (LavaVegetationPatchFeature.isExposed(world, positions, mutable)) continue;
            lavaGroundPatch.add(positions);
        }
        for (BlockPos positions : lavaGroundPatch) {
            world.setBlock(positions, Blocks.LAVA.defaultBlockState(), 2);
        }
        return lavaGroundPatch;
    }

    private static boolean isExposed(WorldGenLevel world, BlockPos pos, BlockPos.MutableBlockPos mutable) {
        return LavaVegetationPatchFeature.isExposedDirection(world, pos, mutable, Direction.NORTH) || LavaVegetationPatchFeature.isExposedDirection(world, pos, mutable, Direction.EAST) || LavaVegetationPatchFeature.isExposedDirection(world, pos, mutable, Direction.SOUTH) || LavaVegetationPatchFeature.isExposedDirection(world, pos, mutable, Direction.WEST) || LavaVegetationPatchFeature.isExposedDirection(world, pos, mutable, Direction.DOWN);
    }

    private static boolean isExposedDirection(WorldGenLevel world, BlockPos pos, BlockPos.MutableBlockPos mutable, Direction direction) {
        mutable.setWithOffset((Vec3i)pos, direction);
        return !world.getBlockState((BlockPos)mutable).isFaceSturdy((BlockGetter)world, (BlockPos)mutable, direction.getOpposite());
    }

    protected boolean placeVegetation(WorldGenLevel world, VegetationPatchConfiguration config, ChunkGenerator generator, RandomSource random, BlockPos pos) {
        return random.nextFloat() < 0.035f && super.placeVegetation(world, config, generator, random, pos.below(2));
    }
}

