/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.worldgen;

import com.naterbobber.darkerdepths.util.DDResourceKeys;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class DDBiomes {
    public static void bootstrap(BootstrapContext<Biome> context) {
        HolderGetter holdergetter = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter holdergetter1 = context.lookup(Registries.CONFIGURED_CARVER);
        context.register(DDResourceKeys.Biomes.MOLTEN_CAVERN, (Object)DDBiomes.createMoltenCavern((HolderGetter<PlacedFeature>)holdergetter, holdergetter1));
        context.register(DDResourceKeys.Biomes.SANDY_CATACOMBS, (Object)DDBiomes.createSandyCatacombs((HolderGetter<PlacedFeature>)holdergetter, holdergetter1));
        context.register(DDResourceKeys.Biomes.GLOWSHROOM_FOREST, (Object)DDBiomes.createGlowshroomForest((HolderGetter<PlacedFeature>)holdergetter, holdergetter1));
    }

    public static Biome createGlowshroomForest(HolderGetter<PlacedFeature> holderGetter, HolderGetter<ConfiguredWorldCarver<?>> holderGetter1) {
        MobSpawnSettings.Builder mobBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(holderGetter, holderGetter1);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultSprings((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addSurfaceFreezing((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addPlainGrass((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        Music music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_DRIPSTONE_CAVES);
        return DDBiomes.biome(true, 0.5f, 0.5f, mobBuilder, biomeBuilder, music);
    }

    public static Biome createMoltenCavern(HolderGetter<PlacedFeature> holderGetter, HolderGetter<ConfiguredWorldCarver<?>> holderGetter1) {
        MobSpawnSettings.Builder mobBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(holderGetter, holderGetter1);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addSurfaceFreezing((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addPlainGrass((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        Music music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_DRIPSTONE_CAVES);
        return DDBiomes.biome(true, 0.5f, 0.5f, mobBuilder, biomeBuilder, music);
    }

    public static Biome createSandyCatacombs(HolderGetter<PlacedFeature> holderGetter, HolderGetter<ConfiguredWorldCarver<?>> holderGetter1) {
        MobSpawnSettings.Builder mobBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(holderGetter, holderGetter1);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.GLOW_LICHEN);
        BiomeDefaultFeatures.addDefaultSprings((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addSurfaceFreezing((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addPlainGrass((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        Music music = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_DRIPSTONE_CAVES);
        return DDBiomes.biome(true, 0.5f, 0.5f, 4169409, 341062, 11976546, mobBuilder, biomeBuilder, music);
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, MobSpawnSettings.Builder mobBuilder, BiomeGenerationSettings.Builder biomeBuilder, @Nullable Music music) {
        return DDBiomes.biome(precipitation, temperature, downfall, 4159204, 329011, 5478752, mobBuilder, biomeBuilder, music);
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, int waterColor, int waterFogColor, int grassColor, MobSpawnSettings.Builder builder, BiomeGenerationSettings.Builder biomeBuilder, @Nullable Music music) {
        return new Biome.BiomeBuilder().hasPrecipitation(precipitation).temperature(temperature).downfall(downfall).specialEffects(new BiomeSpecialEffects.Builder().waterColor(waterColor).waterFogColor(waterFogColor).fogColor(12638463).grassColorOverride(grassColor).skyColor(DDBiomes.calculateSkyColor(temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(music).build()).mobSpawnSettings(builder.build()).generationSettings(biomeBuilder.build()).build();
    }

    protected static int calculateSkyColor(float temperature) {
        float $$1 = temperature / 3.0f;
        $$1 = Mth.clamp((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.hsvToRgb((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }
}

