/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.util;

import com.naterbobber.darkerdepths.component.SuperchargeInfo;
import com.naterbobber.darkerdepths.config.DDConfig;
import com.naterbobber.darkerdepths.init.DDDataComponents;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.Level;

public class SuperchargeHelper {
    private static final ResourceLocation ATTACK_DAMAGE_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"darkerdepths", (String)"supercharge_attack_damage");
    private static final ResourceLocation ATTACK_SPEED_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"darkerdepths", (String)"supercharge_attack_speed");
    private static final ResourceLocation MINING_EFFICIENCY_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"darkerdepths", (String)"supercharge_mining_speed");

    public static void applyUpgrades(ItemStack stack, Level level) {
        if (stack.isEmpty() || level.isClientSide) {
            return;
        }
        ItemAttributeModifiers originalModifiers = (ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        Optional<Unbreakable> originalUnbreakable = Optional.ofNullable((Unbreakable)stack.get(DataComponents.UNBREAKABLE));
        long expirationTick = level.getGameTime() + (long)((Integer)DDConfig.CONFIG.SUPERCHARGE_DURATION.get() * 60) * 20L;
        SuperchargeInfo info = new SuperchargeInfo(expirationTick, originalUnbreakable, originalModifiers);
        stack.set((DataComponentType)DDDataComponents.SUPERCHARGE_INFO.get(), (Object)info);
        MutableComponent prefix = Component.literal((String)"Supercharged ").withStyle(ChatFormatting.AQUA).withStyle(style -> style.withItalic(Boolean.valueOf(false)));
        MutableComponent originalName = stack.getHoverName().copy();
        stack.set(DataComponents.CUSTOM_NAME, (Object)prefix.append((Component)originalName));
        float damageMultiplier = (float)((Integer)DDConfig.CONFIG.SUPERCHARGE_ATTACK_DAMAGE.get()).intValue() / 100.0f;
        float attackSpeedMultiplier = (float)((Integer)DDConfig.CONFIG.SUPERCHARGE_ATTACK_SPEED.get()).intValue() / 100.0f;
        float miningSpeedMultiplier = (float)((Integer)DDConfig.CONFIG.SUPERCHARGE_DIG_SPEED.get()).intValue() / 100.0f;
        ItemAttributeModifiers newModifiers = originalModifiers.withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(ATTACK_DAMAGE_MODIFIER_ID, (double)damageMultiplier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.ANY).withModifierAdded(Attributes.ATTACK_SPEED, new AttributeModifier(ATTACK_SPEED_MODIFIER_ID, (double)attackSpeedMultiplier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.ANY).withModifierAdded(Attributes.MINING_EFFICIENCY, new AttributeModifier(MINING_EFFICIENCY_MODIFIER_ID, (double)miningSpeedMultiplier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.ANY);
        stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)newModifiers.withTooltip(false));
        if (((Boolean)DDConfig.CONFIG.SUPERCHARGE_UNBREAKABLE.get()).booleanValue()) {
            stack.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(false));
        }
    }

    public static void revertUpgrades(ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        SuperchargeInfo info = (SuperchargeInfo)stack.get((DataComponentType)DDDataComponents.SUPERCHARGE_INFO.get());
        if (info == null) {
            return;
        }
        stack.remove((DataComponentType)DDDataComponents.SUPERCHARGE_INFO.get());
        stack.remove(DataComponents.CUSTOM_NAME);
        if (info.originalModifiers().modifiers().isEmpty()) {
            stack.remove(DataComponents.ATTRIBUTE_MODIFIERS);
        } else {
            stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)info.originalModifiers());
        }
        if (info.originalUnbreakable().isPresent()) {
            stack.set(DataComponents.UNBREAKABLE, (Object)info.originalUnbreakable().get());
        } else {
            stack.remove(DataComponents.UNBREAKABLE);
        }
    }
}

