/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.item;

import com.naterbobber.darkerdepths.entities.PetrifiedBoatEntity;
import com.naterbobber.darkerdepths.entities.PetrifiedChestBoatEntity;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DDBoatItem
extends Item {
    private static final Predicate<Entity> NON_COLLIDABLE_ENTITIES = EntitySelector.NO_SPECTATORS.and(Entity::canBeCollidedWith);
    private final PetrifiedBoatEntity.BoatType type;
    private final boolean hasChest;

    public DDBoatItem(boolean hasChest, PetrifiedBoatEntity.BoatType typeIn, Item.Properties properties) {
        super(properties);
        this.type = typeIn;
        this.hasChest = hasChest;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        BlockHitResult raytraceresult = DDBoatItem.getPlayerPOVHitResult((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (raytraceresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        Vec3 vector3d = playerIn.getViewVector(1.0f);
        List list = worldIn.getEntities((Entity)playerIn, playerIn.getBoundingBox().expandTowards(vector3d.scale(5.0)).inflate(1.0), NON_COLLIDABLE_ENTITIES);
        if (!list.isEmpty()) {
            Vec3 vector3d1 = playerIn.getEyePosition(1.0f);
            for (Entity entity : list) {
                AABB axisalignedbb = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!axisalignedbb.contains(vector3d1)) continue;
                return InteractionResultHolder.pass((Object)itemstack);
            }
        }
        if (raytraceresult.getType() == HitResult.Type.BLOCK) {
            PetrifiedBoatEntity boatentity = this.getBoat(worldIn, (HitResult)raytraceresult);
            boatentity.setBoatType(this.type);
            boatentity.setYRot(playerIn.getYRot());
            if (!worldIn.noCollision((Entity)boatentity, boatentity.getBoundingBox())) {
                return InteractionResultHolder.fail((Object)itemstack);
            }
            if (!worldIn.isClientSide) {
                worldIn.addFreshEntity((Entity)boatentity);
                if (!playerIn.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
            }
            playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)worldIn.isClientSide());
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    private PetrifiedBoatEntity getBoat(Level world, HitResult hit) {
        return this.hasChest ? new PetrifiedChestBoatEntity(world, hit.getLocation().x, hit.getLocation().y, hit.getLocation().z) : new PetrifiedBoatEntity(world, hit.getLocation().x, hit.getLocation().y, hit.getLocation().z);
    }
}

