/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.events;

import com.naterbobber.darkerdepths.api.DeathAnchorLocation;
import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.init.DDDataComponents;
import com.naterbobber.darkerdepths.init.DDEnchantmentEffects;
import com.naterbobber.darkerdepths.init.DDItems;
import com.naterbobber.darkerdepths.init.DDMobEffects;
import com.naterbobber.darkerdepths.init.DDPoiTypes;
import com.naterbobber.darkerdepths.network.SendDeathAnchorPacket;
import com.naterbobber.darkerdepths.util.DDResourceKeys;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableFloat;

@EventBusSubscriber(modid="darkerdepths")
public class LivingEvents {
    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        Player player;
        Level level;
        LivingEntity entity = event.getEntity();
        DamageSource damageSource = event.getSource();
        Entity damageSourceEntity = damageSource.getEntity();
        if (entity.hasEffect(DDMobEffects.SOUL_BINDING) && entity.getEffect(DDMobEffects.SOUL_BINDING).getDuration() > 0) {
            event.setNewDamage(0.0f);
        }
        if (damageSourceEntity instanceof Player && (level = (player = (Player)damageSourceEntity).level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack itemStack = player.getItemInHand(player.getUsedItemHand());
            if (itemStack.is((Item)DDItems.STILETTO.get())) {
                MutableFloat mutableFloat = new MutableFloat(0.0f);
                EnchantmentHelper.runIterationOnItem((ItemStack)itemStack, (holder, i) -> ((Enchantment)holder.value()).modifyItemFilteredCount(DDEnchantmentEffects.SWIFT_STRIKE_HIT.get(), serverLevel, i, itemStack, mutableFloat));
                int swiftStrike = Math.max(0, mutableFloat.intValue());
                if (swiftStrike > 0 && (Integer)itemStack.getOrDefault(DDDataComponents.STILETTO_TIME, (Object)0) > 0) {
                    player.getCooldowns().removeCooldown(itemStack.getItem());
                    entity.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            DeathAnchorLocation deathAnchorLocation;
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof DeathAnchorLocation && (deathAnchorLocation = (DeathAnchorLocation)entity).getDeathAnchorLocation().isPresent()) {
                GlobalPos globalPos = deathAnchorLocation.getDeathAnchorLocation().get();
                ResourceKey resourcekey = globalPos.dimension();
                ServerLevel newServer = serverLevel.getServer().getLevel(resourcekey);
                ResourceKey key = DDPoiTypes.DEATH_ANCHOR.getKey();
                if (key == null || newServer == null) {
                    return;
                }
                BlockPos pos = globalPos.pos();
                boolean exists = newServer.getPoiManager().existsAtPosition(key, pos);
                if (!exists) {
                    return;
                }
                event.setCanceled(true);
                entity.setHealth(1.0f);
                BlockPos teleportPos = pos.above();
                if (!serverLevel.getBlockState(teleportPos).isAir()) {
                    boolean safe = false;
                    int radius = 1;
                    for (int y = -radius; y <= radius; ++y) {
                        for (int x = -radius; x <= radius; ++x) {
                            for (int z = -radius; z <= radius; ++z) {
                                BlockPos blockPos = teleportPos.offset(x, y, z);
                                Vec3 vec3 = DismountHelper.findSafeDismountLocation((EntityType)entity.getType(), (CollisionGetter)serverLevel, (BlockPos)blockPos, (boolean)true);
                                if (vec3 == null) continue;
                                teleportPos = BlockPos.containing((Position)vec3);
                                safe = true;
                            }
                        }
                    }
                    if (!safe && serverLevel.getBlockState(teleportPos).is(BlockTags.FEATURES_CANNOT_REPLACE) && serverLevel.getBlockState(teleportPos.above()).is(BlockTags.FEATURES_CANNOT_REPLACE)) {
                        serverLevel.destroyBlock(teleportPos, false);
                        serverLevel.destroyBlock(teleportPos.above(), false);
                    }
                }
                entity.addEffect(new MobEffectInstance(DDMobEffects.SOUL_BINDING, 200, 0, true, false));
                entity.teleportTo(newServer, (double)teleportPos.getX() + 0.5, (double)teleportPos.getY(), (double)teleportPos.getZ() + 0.5, Set.of(), 0.0f, 0.0f);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SendDeathAnchorPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                entity.setRemainingFireTicks(0);
            }
        }
    }

    @SubscribeEvent
    public static void onMobEffectRemove(MobEffectEvent.Remove event) {
        if (event.getEffect() == DDMobEffects.SOUL_BINDING.get()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onMobEffectExpired(MobEffectEvent.Expired event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null && effectInstance.getEffect().value() == DDMobEffects.SOUL_BINDING.get()) {
            DeathAnchorLocation deathAnchorLocation;
            if (entity instanceof DeathAnchorLocation && (deathAnchorLocation = (DeathAnchorLocation)entity).getDeathAnchorLocation().isPresent()) {
                ServerLevel serverLevel;
                ServerLevel newServer;
                GlobalPos globalPos = deathAnchorLocation.getDeathAnchorLocation().get();
                ResourceKey resourcekey = globalPos.dimension();
                BlockPos pos = globalPos.pos();
                ResourceKey key = DDPoiTypes.DEATH_ANCHOR.getKey();
                if (key == null) {
                    return;
                }
                Level level = entity.level();
                if (level instanceof ServerLevel && (newServer = (serverLevel = (ServerLevel)level).getServer().getLevel(resourcekey)) != null && newServer.getPoiManager().existsAtPosition(key, pos)) {
                    newServer.scheduleTick(pos, (Block)DDBlocks.DEATH_ANCHOR.get(), 2);
                }
                deathAnchorLocation.setDeathAnchorLocation(Optional.empty());
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!player.getAbilities().instabuild) {
                    DamageSource damageSource = new DamageSource((Holder)entity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DDResourceKeys.DamageTypes.SOUL_BINDING_DAMAGE));
                    entity.hurt(damageSource, Float.MAX_VALUE);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).level().isClientSide()) {
            return;
        }
        if (event.getSlot() != EquipmentSlot.HEAD) {
            return;
        }
        ItemStack newlyEquipped = event.getTo();
        ItemStack previouslyEquipped = event.getFrom();
        if (newlyEquipped.is((Item)DDItems.GLOWSHROOM_CAP.get())) {
            player.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, -1, 0, false, false, true));
        }
        if (previouslyEquipped.is((Item)DDItems.GLOWSHROOM_CAP.get()) && !newlyEquipped.is((Item)DDItems.GLOWSHROOM_CAP.get())) {
            player.removeEffect(MobEffects.DIG_SPEED);
        }
    }
}

