/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.entities.goals;

import com.naterbobber.darkerdepths.entities.goals.IDashable;
import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DashGoal
extends Goal {
    private final Mob mob;
    private LivingEntity target;
    private final double dashSpeed;
    private final double yBoost;
    private final double triggerDistanceSquare;
    private final int dashDurationTicks;
    private final int cooldownTicks;
    private final int prepareTicks;
    private int actionTicks;
    private int currentCooldown;

    public DashGoal(Mob mob, double dashSpeed, double yBoost, double triggerDistance, int dashDurationTicks, int cooldownTicks, int prepareTicks) {
        this.mob = mob;
        this.dashSpeed = dashSpeed;
        this.yBoost = yBoost;
        this.triggerDistanceSquare = triggerDistance * triggerDistance;
        this.dashDurationTicks = dashDurationTicks;
        this.cooldownTicks = cooldownTicks;
        this.prepareTicks = prepareTicks;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        if (this.currentCooldown > 0) {
            --this.currentCooldown;
            return false;
        }
        this.target = this.mob.getTarget();
        if (this.target == null) {
            return false;
        }
        return this.mob.distanceToSqr((Entity)this.target) > this.triggerDistanceSquare && this.mob.onGround();
    }

    public void start() {
        this.actionTicks = this.prepareTicks + this.dashDurationTicks;
        Mob mob = this.mob;
        if (mob instanceof IDashable) {
            IDashable dashable = (IDashable)mob;
            dashable.setPreparingToDash(true);
        }
    }

    public void stop() {
        Mob mob = this.mob;
        if (mob instanceof IDashable) {
            IDashable dashable = (IDashable)mob;
            dashable.setPreparingToDash(false);
            dashable.setDashing(false);
        }
        this.currentCooldown = this.cooldownTicks;
        this.mob.getNavigation().stop();
    }

    public void tick() {
        --this.actionTicks;
        if (this.actionTicks == this.dashDurationTicks) {
            Vec3 initialVelocity = this.mob.position().vectorTo(this.target.position()).normalize().scale(this.dashSpeed);
            Vec3 finalVelocity = new Vec3(initialVelocity.x(), this.yBoost, initialVelocity.z());
            this.mob.setDeltaMovement(finalVelocity);
            this.mob.playSound(SoundEvents.PLAYER_ATTACK_SWEEP, 1.0f, 1.2f);
            Level level = this.mob.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.POOF, this.mob.getX(), this.mob.getY(0.5), this.mob.getZ(), 15, 0.3, 0.2, 0.3, 0.05);
            }
            if ((level = this.mob) instanceof IDashable) {
                IDashable dashable = (IDashable)level;
                dashable.setPreparingToDash(false);
                dashable.setDashing(true);
            }
        }
        if (this.target != null) {
            this.mob.getLookControl().setLookAt((Entity)this.target);
        }
    }

    public boolean canContinueToUse() {
        return this.actionTicks > 0 && this.target != null && this.target.isAlive();
    }
}

