/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.entities;

import com.naterbobber.darkerdepths.entities.goals.ConfigurableRandomFlyingGoal;
import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.init.DDItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VoidSoulEntity
extends PathfinderMob
implements GeoEntity {
    private boolean isCaptured = false;
    private int lifetime = 1200;
    private int experienceDrop = 12;
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("idle");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> EXPIRES = SynchedEntityData.defineId(VoidSoulEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public VoidSoulEntity(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.setNoGravity(true);
        this.setPersistenceRequired();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.35f).add(Attributes.FLYING_SPEED, (double)0.35f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.2, 1.5));
        this.goalSelector.addGoal(2, (Goal)new ConfigurableRandomFlyingGoal(this, 1.0, 10));
    }

    public void tick() {
        super.tick();
    }

    public void aiStep() {
        super.aiStep();
        if (this.expires()) {
            if (this.lifetime > 0) {
                --this.lifetime;
            } else {
                this.kill();
            }
        }
    }

    protected PathNavigation createNavigation(Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel);
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(true);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    public InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.getItemInHand(pHand);
        if (itemStack.is(Items.GLASS_BOTTLE)) {
            this.isCaptured = true;
            this.kill();
            this.playSound(SoundEvents.BOTTLE_FILL_DRAGONBREATH);
            ItemStack voidSoulJarStack = new ItemStack((ItemLike)DDBlocks.VOID_SOUL_JAR.get());
            if (!pPlayer.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            if (itemStack.isEmpty()) {
                pPlayer.setItemInHand(pHand, voidSoulJarStack);
            } else if (!pPlayer.getInventory().add(voidSoulJarStack)) {
                pPlayer.drop(voidSoulJarStack, false);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if (itemStack.is((Item)DDItems.AMBER.get()) && this.expires()) {
            this.setExpires(false);
            this.playSound(SoundEvents.AMETHYST_BLOCK_RESONATE);
            if (!this.level().isClientSide()) {
                ServerLevel serverLevel = (ServerLevel)this.level();
                SimpleParticleType particle = ParticleTypes.WAX_ON;
                serverLevel.sendParticles((ParticleOptions)particle, this.getX(), this.getY(0.5), this.getZ(), 7, (double)this.getBbWidth() / 2.0, (double)this.getBbHeight() / 2.0, (double)this.getBbWidth() / 2.0, 0.05);
            }
            if (!pPlayer.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(pPlayer, pHand);
    }

    public void die(DamageSource pDamageSource) {
        if (!this.level().isClientSide()) {
            ServerLevel serverLevel = (ServerLevel)this.level();
            if (!this.isCaptured) {
                SimpleParticleType particle = ParticleTypes.LARGE_SMOKE;
                serverLevel.sendParticles((ParticleOptions)particle, this.getX(), this.getY(0.5), this.getZ(), 30, (double)this.getBbWidth() / 2.0, (double)this.getBbHeight() / 2.0, (double)this.getBbWidth() / 2.0, 0.05);
                if (this.experienceDrop > 0) {
                    this.dropExperience((Entity)this);
                }
            } else {
                SimpleParticleType particle = ParticleTypes.SMOKE;
                serverLevel.sendParticles((ParticleOptions)particle, this.getX(), this.getY(0.5), this.getZ(), 5, (double)this.getBbWidth() / 3.0, (double)this.getBbHeight() / 3.0, (double)this.getBbWidth() / 3.0, 0.05);
            }
        }
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent((Holder)GameEvent.ENTITY_DIE);
    }

    protected void checkFallDamage(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (pSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurt(pSource, pAmount);
        }
        return false;
    }

    public void handleDamageEvent(DamageSource pDamageSource) {
    }

    public void knockback(double pStrength, double pX, double pZ) {
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return false;
    }

    public boolean isOnFire() {
        return false;
    }

    protected void dropExperience(@Nullable Entity entity) {
        ExperienceOrb.award((ServerLevel)((ServerLevel)this.level()), (Vec3)this.position(), (int)this.experienceDrop);
    }

    public void setExperienceDrop(int amount) {
        this.experienceDrop = amount;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("expires", this.expires());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("expires")) {
            this.setExpires(compound.getBoolean("expires"));
        }
        this.registerGoals();
    }

    public boolean expires() {
        return (Boolean)this.entityData.get(EXPIRES);
    }

    public void setExpires(boolean expires) {
        this.entityData.set(EXPIRES, (Object)expires);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(EXPIRES, (Object)true);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "walkingController", 5, this::predicate));
    }

    protected <E extends VoidSoulEntity> PlayState predicate(AnimationState<E> event) {
        return event.setAndContinue(IDLE_ANIM);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return null;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.EMPTY;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ALLAY_AMBIENT_WITHOUT_ITEM;
    }
}

